/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Statistics;

import arjuna.JavaSim.Statistics.Bucket;
import arjuna.JavaSim.Statistics.PrecisionHistogram;

public class Quantile
extends PrecisionHistogram {
    private double qProb;

    public Quantile() {
        this.qProb = 0.95;
    }

    public Quantile(double q) throws IllegalArgumentException {
        this.qProb = q;
        if (q <= 0.0 || q > 1.0) {
            throw new IllegalArgumentException("Quantile::Quantile ( " + q + " ) : bad value.");
        }
    }

    public double getValue() {
        double pSamples = (double)this.numberOfSamples() * this.qProb;
        long nEntries = 0L;
        Bucket trail = null;
        for (Bucket ptr = this.Head; (double)nEntries < pSamples && ptr != null; ptr = ptr.cdr()) {
            nEntries += ptr.size();
            trail = ptr;
        }
        return trail.Name();
    }

    public double range() {
        return this.qProb;
    }

    public void print() {
        System.out.println("Quantile precentage : " + this.qProb);
        System.out.println("Value below which percentage occurs " + this.getValue());
        super.print();
    }
}

