/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesWrapper;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionApplicationFactory
extends ApplicationFactory
implements FacesWrapper<ApplicationFactory> {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private ApplicationFactory delegate;
    private Application defaultApplication;
    private Field defaultApplicationField;
    private volatile Application application;

    public InjectionApplicationFactory(ApplicationFactory delegate) {
        Util.notNull("applicationFactory", delegate);
        this.delegate = delegate;
    }

    public Application getApplication() {
        if (this.application == null) {
            this.application = this.delegate.getApplication();
            if (this.application == null) {
                String message = MessageFormat.format("Delegate ApplicationContextFactory, {0}, returned null when calling getApplication().", this.delegate.getClass().getName());
                throw new IllegalStateException(message);
            }
            this.injectDefaultApplication();
        }
        return this.application;
    }

    public synchronized void setApplication(Application application) {
        this.application = application;
        this.delegate.setApplication(application);
        this.injectDefaultApplication();
    }

    public ApplicationFactory getWrapped() {
        return this.delegate;
    }

    private void injectDefaultApplication() {
        block7: {
            if (this.defaultApplication == null) {
                FacesContext ctx = FacesContext.getCurrentInstance();
                String attrName = ApplicationImpl.class.getName();
                this.defaultApplication = (Application)ctx.getExternalContext().getApplicationMap().get(attrName);
                ctx.getExternalContext().getApplicationMap().remove(attrName);
            }
            if (this.defaultApplication != null) {
                try {
                    if (this.defaultApplicationField == null) {
                        this.defaultApplicationField = Application.class.getDeclaredField("defaultApplication");
                        this.defaultApplicationField.setAccessible(true);
                    }
                    this.defaultApplicationField.set(this.application, this.defaultApplication);
                }
                catch (NoSuchFieldException nsfe) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Unable to find private field named 'defaultApplication' in javax.faces.application.Application.");
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block7;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }
}

