/*
 * Decompiled with CFR 0.152.
 */
package javax.slee;

import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class AddressPlan
implements Serializable {
    public static final int ADDRESS_PLAN_NOT_PRESENT = -1;
    public static final int ADDRESS_PLAN_UNDEFINED = 0;
    public static final int ADDRESS_PLAN_IP = 1;
    public static final int ADDRESS_PLAN_MULTICAST = 2;
    public static final int ADDRESS_PLAN_UNICAST = 3;
    public static final int ADDRESS_PLAN_E164 = 4;
    public static final int ADDRESS_PLAN_AESA = 5;
    public static final int ADDRESS_PLAN_URI = 6;
    public static final int ADDRESS_PLAN_NSAP = 7;
    public static final int ADDRESS_PLAN_SMTP = 8;
    public static final int ADDRESS_PLAN_X400 = 10;
    public static final int ADDRESS_PLAN_SIP = 11;
    public static final int ADDRESS_PLAN_E164_MOBILE = 13;
    public static final int ADDRESS_PLAN_H323 = 14;
    public static final int ADDRESS_PLAN_GT = 15;
    public static final int ADDRESS_PLAN_SSN = 16;
    public static final int ADDRESS_PLAN_SLEE_PROFILE_TABLE = 20;
    public static final int ADDRESS_PLAN_SLEE_PROFILE = 21;
    public static final String NOT_PRESENT_STRING = "Not Present";
    public static final String UNDEFINED_STRING = "Undefined";
    public static final String IP_STRING = "IP";
    public static final String MULTICAST_STRING = "Multicast";
    public static final String UNICAST_STRING = "Unicast";
    public static final String E164_STRING = "E.164";
    public static final String AESA_STRING = "AESA";
    public static final String URI_STRING = "URI";
    public static final String NSAP_STRING = "NSAP";
    public static final String SMTP_STRING = "SMTP";
    public static final String E164_MOBILE_STRING = "E.164 Mobile";
    public static final String X400_STRING = "X400";
    public static final String SIP_STRING = "SIP";
    public static final String H323_STRING = "H323";
    public static final String GT_STRING = "GT";
    public static final String SSN_STRING = "SSN";
    public static final String SLEE_PROFILE_TABLE_STRING = "SLEE ProfileTable";
    public static final String SLEE_PROFILE_STRING = "SLEE Profile";
    public static final AddressPlan NOT_PRESENT = new AddressPlan(-1);
    public static final AddressPlan UNDEFINED = new AddressPlan(0);
    public static final AddressPlan IP = new AddressPlan(1);
    public static final AddressPlan MULTICAST = new AddressPlan(2);
    public static final AddressPlan UNICAST = new AddressPlan(3);
    public static final AddressPlan E164 = new AddressPlan(4);
    public static final AddressPlan AESA = new AddressPlan(5);
    public static final AddressPlan URI = new AddressPlan(6);
    public static final AddressPlan NSAP = new AddressPlan(7);
    public static final AddressPlan SMTP = new AddressPlan(8);
    public static final AddressPlan E164_MOBILE = new AddressPlan(13);
    public static final AddressPlan X400 = new AddressPlan(10);
    public static final AddressPlan SIP = new AddressPlan(11);
    public static final AddressPlan H323 = new AddressPlan(14);
    public static final AddressPlan GT = new AddressPlan(15);
    public static final AddressPlan SSN = new AddressPlan(16);
    public static final AddressPlan SLEE_PROFILE_TABLE = new AddressPlan(20);
    public static final AddressPlan SLEE_PROFILE = new AddressPlan(21);
    private final int plan;

    public static AddressPlan fromInt(int plan) throws IllegalArgumentException {
        switch (plan) {
            case -1: {
                return NOT_PRESENT;
            }
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return IP;
            }
            case 2: {
                return MULTICAST;
            }
            case 3: {
                return UNICAST;
            }
            case 4: {
                return E164;
            }
            case 5: {
                return AESA;
            }
            case 6: {
                return URI;
            }
            case 7: {
                return NSAP;
            }
            case 8: {
                return SMTP;
            }
            case 10: {
                return X400;
            }
            case 11: {
                return SIP;
            }
            case 13: {
                return E164_MOBILE;
            }
            case 14: {
                return H323;
            }
            case 15: {
                return GT;
            }
            case 16: {
                return SSN;
            }
            case 20: {
                return SLEE_PROFILE_TABLE;
            }
            case 21: {
                return SLEE_PROFILE;
            }
        }
        throw new IllegalArgumentException("Invalid address plan: " + plan);
    }

    public static AddressPlan fromString(String plan) throws NullPointerException, IllegalArgumentException {
        if (plan == null) {
            throw new NullPointerException("plan is null");
        }
        if (plan.equalsIgnoreCase(NOT_PRESENT_STRING)) {
            return NOT_PRESENT;
        }
        if (plan.equalsIgnoreCase(UNDEFINED_STRING)) {
            return UNDEFINED;
        }
        if (plan.equalsIgnoreCase(IP_STRING)) {
            return IP;
        }
        if (plan.equalsIgnoreCase(MULTICAST_STRING)) {
            return MULTICAST;
        }
        if (plan.equalsIgnoreCase(UNICAST_STRING)) {
            return UNICAST;
        }
        if (plan.equalsIgnoreCase(E164_STRING)) {
            return E164;
        }
        if (plan.equalsIgnoreCase(AESA_STRING)) {
            return AESA;
        }
        if (plan.equalsIgnoreCase(URI_STRING)) {
            return URI;
        }
        if (plan.equalsIgnoreCase(NSAP_STRING)) {
            return NSAP;
        }
        if (plan.equalsIgnoreCase(SMTP_STRING)) {
            return SMTP;
        }
        if (plan.equalsIgnoreCase(X400_STRING)) {
            return X400;
        }
        if (plan.equalsIgnoreCase(SIP_STRING)) {
            return SIP;
        }
        if (plan.equalsIgnoreCase(E164_MOBILE_STRING)) {
            return E164_MOBILE;
        }
        if (plan.equalsIgnoreCase(H323_STRING)) {
            return H323;
        }
        if (plan.equalsIgnoreCase(GT_STRING)) {
            return GT;
        }
        if (plan.equalsIgnoreCase(SSN_STRING)) {
            return SSN;
        }
        if (plan.equalsIgnoreCase(SLEE_PROFILE_TABLE_STRING)) {
            return SLEE_PROFILE_TABLE;
        }
        if (plan.equalsIgnoreCase(SLEE_PROFILE_STRING)) {
            return SLEE_PROFILE;
        }
        throw new IllegalArgumentException("Invalid address plan: " + plan);
    }

    public int toInt() {
        return this.plan;
    }

    public boolean isNotPresent() {
        return this.plan == -1;
    }

    public boolean isUndefined() {
        return this.plan == 0;
    }

    public boolean isIP() {
        return this.plan == 1;
    }

    public boolean isMulticast() {
        return this.plan == 2;
    }

    public boolean isUnicast() {
        return this.plan == 3;
    }

    public boolean isE164() {
        return this.plan == 4;
    }

    public boolean isAESA() {
        return this.plan == 5;
    }

    public boolean isURI() {
        return this.plan == 6;
    }

    public boolean isNSAP() {
        return this.plan == 7;
    }

    public boolean isSMTP() {
        return this.plan == 8;
    }

    public boolean isX400() {
        return this.plan == 10;
    }

    public boolean isSIP() {
        return this.plan == 11;
    }

    public boolean isE164Mobile() {
        return this.plan == 13;
    }

    public boolean isH323() {
        return this.plan == 14;
    }

    public boolean isGT() {
        return this.plan == 15;
    }

    public boolean isSSN() {
        return this.plan == 16;
    }

    public boolean isSleeProfileTable() {
        return this.plan == 20;
    }

    public boolean isSleeProfile() {
        return this.plan == 21;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof AddressPlan && ((AddressPlan)obj).plan == this.plan;
    }

    public int hashCode() {
        return this.plan;
    }

    public String toString() {
        switch (this.plan) {
            case -1: {
                return NOT_PRESENT_STRING;
            }
            case 0: {
                return UNDEFINED_STRING;
            }
            case 1: {
                return IP_STRING;
            }
            case 2: {
                return MULTICAST_STRING;
            }
            case 3: {
                return UNICAST_STRING;
            }
            case 4: {
                return E164_STRING;
            }
            case 5: {
                return AESA_STRING;
            }
            case 6: {
                return URI_STRING;
            }
            case 7: {
                return NSAP_STRING;
            }
            case 8: {
                return SMTP_STRING;
            }
            case 10: {
                return X400_STRING;
            }
            case 11: {
                return SIP_STRING;
            }
            case 13: {
                return E164_MOBILE_STRING;
            }
            case 14: {
                return H323_STRING;
            }
            case 15: {
                return GT_STRING;
            }
            case 16: {
                return SSN_STRING;
            }
            case 20: {
                return SLEE_PROFILE_TABLE_STRING;
            }
            case 21: {
                return SLEE_PROFILE_STRING;
            }
        }
        return "AddressPlan in Unknown and Invalid State";
    }

    private AddressPlan(int plan) {
        this.plan = plan;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return AddressPlan.fromInt(this.plan);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found");
        }
    }
}

