/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.facilities;

import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class TimerPreserveMissed
implements Serializable {
    public static final int PRESERVE_NONE = 0;
    public static final int PRESERVE_ALL = 1;
    public static final int PRESERVE_LAST = 2;
    public static final String NONE_STRING = "None";
    public static final String ALL_STRING = "All";
    public static final String LAST_STRING = "Last";
    public static final TimerPreserveMissed NONE = new TimerPreserveMissed(0);
    public static final TimerPreserveMissed ALL = new TimerPreserveMissed(1);
    public static final TimerPreserveMissed LAST = new TimerPreserveMissed(2);
    private final int option;

    public static TimerPreserveMissed fromInt(int option) throws IllegalArgumentException {
        switch (option) {
            case 0: {
                return NONE;
            }
            case 1: {
                return ALL;
            }
            case 2: {
                return LAST;
            }
        }
        throw new IllegalArgumentException("Invalid preserve-missed value: " + option);
    }

    public static TimerPreserveMissed fromString(String option) throws NullPointerException, IllegalArgumentException {
        if (option == null) {
            throw new NullPointerException("option is null");
        }
        if (option.equalsIgnoreCase(NONE_STRING)) {
            return NONE;
        }
        if (option.equalsIgnoreCase(ALL_STRING)) {
            return ALL;
        }
        if (option.equalsIgnoreCase(LAST_STRING)) {
            return LAST;
        }
        throw new IllegalArgumentException("Invalid preserve-missed value: " + option);
    }

    public int toInt() {
        return this.option;
    }

    public boolean isNone() {
        return this.option == 0;
    }

    public boolean isAll() {
        return this.option == 1;
    }

    public boolean isLast() {
        return this.option == 2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof TimerPreserveMissed && ((TimerPreserveMissed)obj).option == this.option;
    }

    public int hashCode() {
        return this.option;
    }

    public String toString() {
        switch (this.option) {
            case 0: {
                return NONE_STRING;
            }
            case 1: {
                return ALL_STRING;
            }
            case 2: {
                return LAST_STRING;
            }
        }
        return "TimerPreserveMissed in Unknown and Invalid State";
    }

    private TimerPreserveMissed(int option) {
        this.option = option;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return TimerPreserveMissed.fromInt(this.option);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found");
        }
    }
}

