/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.facilities;

import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class TraceLevel
implements Serializable {
    public static final int LEVEL_OFF = 0;
    public static final int LEVEL_SEVERE = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_CONFIG = 4;
    public static final int LEVEL_FINE = 5;
    public static final int LEVEL_FINER = 6;
    public static final int LEVEL_FINEST = 7;
    public static final String OFF_STRING = "Off";
    public static final String SEVERE_STRING = "Severe";
    public static final String WARNING_STRING = "Warning";
    public static final String INFO_STRING = "Info";
    public static final String CONFIG_STRING = "Config";
    public static final String FINE_STRING = "Fine";
    public static final String FINER_STRING = "Finer";
    public static final String FINEST_STRING = "Finest";
    public static final TraceLevel OFF = new TraceLevel(0);
    public static final TraceLevel SEVERE = new TraceLevel(1);
    public static final TraceLevel WARNING = new TraceLevel(2);
    public static final TraceLevel INFO = new TraceLevel(3);
    public static final TraceLevel CONFIG = new TraceLevel(4);
    public static final TraceLevel FINE = new TraceLevel(5);
    public static final TraceLevel FINER = new TraceLevel(6);
    public static final TraceLevel FINEST = new TraceLevel(7);
    private final int level;

    public static TraceLevel fromInt(int level) throws IllegalArgumentException {
        switch (level) {
            case 0: {
                return OFF;
            }
            case 1: {
                return SEVERE;
            }
            case 2: {
                return WARNING;
            }
            case 3: {
                return INFO;
            }
            case 4: {
                return CONFIG;
            }
            case 5: {
                return FINE;
            }
            case 6: {
                return FINER;
            }
            case 7: {
                return FINEST;
            }
        }
        throw new IllegalArgumentException("Invalid level: " + level);
    }

    public static TraceLevel fromString(String level) throws NullPointerException, IllegalArgumentException {
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        if (level.equalsIgnoreCase(OFF_STRING)) {
            return OFF;
        }
        if (level.equalsIgnoreCase(SEVERE_STRING)) {
            return SEVERE;
        }
        if (level.equalsIgnoreCase(WARNING_STRING)) {
            return WARNING;
        }
        if (level.equalsIgnoreCase(INFO_STRING)) {
            return INFO;
        }
        if (level.equalsIgnoreCase(CONFIG_STRING)) {
            return CONFIG;
        }
        if (level.equalsIgnoreCase(FINE_STRING)) {
            return FINE;
        }
        if (level.equalsIgnoreCase(FINER_STRING)) {
            return FINER;
        }
        if (level.equalsIgnoreCase(FINEST_STRING)) {
            return FINEST;
        }
        throw new IllegalArgumentException("Invalid level: " + level);
    }

    public int toInt() {
        return this.level;
    }

    public boolean isOff() {
        return this.level == 0;
    }

    public boolean isSevere() {
        return this.level == 1;
    }

    public boolean isWarning() {
        return this.level == 2;
    }

    public boolean isInfo() {
        return this.level == 3;
    }

    public boolean isConfig() {
        return this.level == 4;
    }

    public boolean isFine() {
        return this.level == 5;
    }

    public boolean isFiner() {
        return this.level == 6;
    }

    public boolean isFinest() {
        return this.level == 7;
    }

    public boolean isHigherLevel(TraceLevel other) throws NullPointerException {
        if (other == null) {
            throw new NullPointerException("other is null");
        }
        return this.level < other.level;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof TraceLevel && ((TraceLevel)obj).level == this.level;
    }

    public int hashCode() {
        return this.level;
    }

    public String toString() {
        switch (this.level) {
            case 0: {
                return OFF_STRING;
            }
            case 1: {
                return SEVERE_STRING;
            }
            case 2: {
                return WARNING_STRING;
            }
            case 3: {
                return INFO_STRING;
            }
            case 4: {
                return CONFIG_STRING;
            }
            case 5: {
                return FINE_STRING;
            }
            case 6: {
                return FINER_STRING;
            }
            case 7: {
                return FINEST_STRING;
            }
        }
        return "TraceLevel in Unknown and Invalid State";
    }

    private TraceLevel(int level) {
        this.level = level;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return TraceLevel.fromInt(this.level);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found");
        }
    }
}

