/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.rmi.MarshalledObject;
import javax.slee.facilities.AlarmLevel;
import javax.slee.management.NotificationSource;
import javax.slee.management.VendorExtensionUtils;
import javax.slee.management.VendorExtensions;

public final class Alarm
implements VendorExtensions,
Serializable,
Comparable {
    private final String alarmID;
    private final NotificationSource notificationSource;
    private final String alarmType;
    private final String instanceID;
    private final AlarmLevel level;
    private final String message;
    private final long timestamp;
    private transient Throwable cause;
    private static volatile boolean vendorDataSerializationEnabled = false;
    private static volatile boolean vendorDataDeserializationEnabled = false;
    private transient Object vendorData;

    public Alarm(String alarmID, NotificationSource notificationSource, String alarmType, String instanceID, AlarmLevel level, String message, Throwable cause, long timestamp) throws NullPointerException {
        if (alarmID == null) {
            throw new NullPointerException("alarmID is null");
        }
        if (notificationSource == null) {
            throw new NullPointerException("notificationSource is null");
        }
        if (alarmType == null) {
            throw new NullPointerException("alarmType is null");
        }
        if (instanceID == null) {
            throw new NullPointerException("instanceID is null");
        }
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        this.alarmID = alarmID;
        this.notificationSource = notificationSource;
        this.alarmType = alarmType;
        this.instanceID = instanceID;
        this.level = level;
        this.message = message;
        this.cause = cause;
        this.timestamp = timestamp;
    }

    public String getAlarmID() {
        return this.alarmID;
    }

    public NotificationSource getNotificationSource() {
        return this.notificationSource;
    }

    public String getAlarmType() {
        return this.alarmType;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public AlarmLevel getAlarmLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static void enableVendorDataSerialization() {
        vendorDataSerializationEnabled = true;
    }

    public static void disableVendorDataSerialization() {
        vendorDataSerializationEnabled = false;
    }

    public static void enableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = true;
    }

    public static void disableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = false;
    }

    public void setVendorData(Object vendorData) {
        this.vendorData = vendorData;
    }

    public Object getVendorData() {
        return this.vendorData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Alarm)) {
            return false;
        }
        Alarm that = (Alarm)obj;
        return ((Object)this.notificationSource).equals(that.notificationSource) && this.alarmType.equals(that.alarmType) && this.instanceID.equals(that.instanceID);
    }

    public int hashCode() {
        return ((Object)this.notificationSource).hashCode() ^ this.alarmType.hashCode() ^ this.instanceID.hashCode();
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof Alarm)) {
            throw new ClassCastException("Not a javax.slee.management.Alarm: " + obj);
        }
        Alarm that = (Alarm)obj;
        return this.alarmID.compareTo(that.alarmID);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Alarm[id=").append(this.alarmID).append(",source=").append(this.notificationSource).append(",alarmType=").append(this.alarmType).append(",instanceID=").append(this.instanceID).append(",level=").append(this.level).append(",message=").append(this.message).append(",cause=").append(this.cause).append(",timestamp=").append(this.timestamp);
        if (this.vendorData != null) {
            buf.append(",vendor data=").append(this.vendorData);
        }
        buf.append(']');
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        VendorExtensionUtils.writeObject(out, vendorDataSerializationEnabled ? this.vendorData : null);
        if (this.cause != null) {
            out.writeBoolean(true);
            out.writeObject(new MarshalledObject<Throwable>(this.cause));
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.cause.printStackTrace(pw);
            pw.flush();
            out.writeUTF(sw.getBuffer().toString());
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.vendorData = VendorExtensionUtils.readObject(in, vendorDataDeserializationEnabled);
        if (in.readBoolean()) {
            try {
                this.cause = (Throwable)((MarshalledObject)in.readObject()).get();
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            String causeString = in.readUTF();
            if (this.cause == null) {
                this.cause = new Exception("Undeserializable cause, original cause stack trace follows: " + causeString);
            }
        }
    }
}

