/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import javax.management.ObjectName;
import javax.slee.management.AbstractNotificationSource;
import javax.slee.management.NotificationSource;

public final class ResourceAdaptorEntityNotification
extends AbstractNotificationSource
implements NotificationSource {
    public static final String ALARM_NOTIFICATION_TYPE = "javax.slee.management.alarm.raentity";
    public static final String TRACE_NOTIFICATION_TYPE = "javax.slee.management.trace.raentity";
    public static final String USAGE_NOTIFICATION_TYPE = "javax.slee.management.usage.raentity";
    public static final String RESOURCE_ADAPTOR_ENTITY_NAME_KEY = "raEntityName";
    private final String entityName;
    private static final String TYPE = ResourceAdaptorEntityNotification.class.getName();

    public ResourceAdaptorEntityNotification(String entityName) {
        if (entityName == null) {
            throw new NullPointerException("entityName is null");
        }
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getAlarmNotificationType() {
        return ALARM_NOTIFICATION_TYPE;
    }

    public String getTraceNotificationType() {
        return TRACE_NOTIFICATION_TYPE;
    }

    public String getUsageNotificationType() {
        return USAGE_NOTIFICATION_TYPE;
    }

    public static String getUsageMBeanProperties(String entityName) {
        if (entityName == null) {
            throw new NullPointerException("entityName is null");
        }
        return "raEntityName=" + ObjectName.quote(entityName);
    }

    public String getUsageMBeanProperties() {
        return ResourceAdaptorEntityNotification.getUsageMBeanProperties(this.entityName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ResourceAdaptorEntityNotification)) {
            return false;
        }
        return this.entityName.equals(((ResourceAdaptorEntityNotification)obj).entityName);
    }

    public int hashCode() {
        return this.entityName.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RAEntityNotification[entity=").append(this.entityName).append(']');
        return buf.toString();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is null");
        }
        if (obj == this) {
            return 0;
        }
        if (obj instanceof ResourceAdaptorEntityNotification) {
            ResourceAdaptorEntityNotification that = (ResourceAdaptorEntityNotification)obj;
            return this.entityName.compareTo(that.entityName);
        }
        return super.compareTo(TYPE, obj);
    }

    protected String getClassName() {
        return TYPE;
    }
}

