/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class ResourceAdaptorEntityState
implements Serializable {
    public static final int ENTITY_INACTIVE = 0;
    public static final int ENTITY_ACTIVE = 1;
    public static final int ENTITY_STOPPING = 2;
    public static final String INACTIVE_STRING = "Inactive";
    public static final String ACTIVE_STRING = "Active";
    public static final String STOPPING_STRING = "Stopping";
    public static final ResourceAdaptorEntityState INACTIVE = new ResourceAdaptorEntityState(0);
    public static final ResourceAdaptorEntityState ACTIVE = new ResourceAdaptorEntityState(1);
    public static final ResourceAdaptorEntityState STOPPING = new ResourceAdaptorEntityState(2);
    private final int state;

    public static ResourceAdaptorEntityState fromInt(int state) throws IllegalArgumentException {
        switch (state) {
            case 0: {
                return INACTIVE;
            }
            case 1: {
                return ACTIVE;
            }
            case 2: {
                return STOPPING;
            }
        }
        throw new IllegalArgumentException("Invalid state: " + state);
    }

    public static ResourceAdaptorEntityState fromString(String state) throws NullPointerException, IllegalArgumentException {
        if (state == null) {
            throw new NullPointerException("state is null");
        }
        if (state.equalsIgnoreCase(INACTIVE_STRING)) {
            return INACTIVE;
        }
        if (state.equalsIgnoreCase(ACTIVE_STRING)) {
            return ACTIVE;
        }
        if (state.equalsIgnoreCase(STOPPING_STRING)) {
            return STOPPING;
        }
        throw new IllegalArgumentException("Invalid state: " + state);
    }

    public int toInt() {
        return this.state;
    }

    public boolean isInactive() {
        return this.state == 0;
    }

    public boolean isActive() {
        return this.state == 1;
    }

    public boolean isStopping() {
        return this.state == 2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof ResourceAdaptorEntityState && ((ResourceAdaptorEntityState)obj).state == this.state;
    }

    public int hashCode() {
        return this.state;
    }

    public String toString() {
        switch (this.state) {
            case 0: {
                return INACTIVE_STRING;
            }
            case 1: {
                return ACTIVE_STRING;
            }
            case 2: {
                return STOPPING_STRING;
            }
        }
        return "ResourceAdaptorEntityState in Unknown and Invalid State";
    }

    private ResourceAdaptorEntityState(int state) {
        this.state = state;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return ResourceAdaptorEntityState.fromInt(this.state);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found");
        }
    }
}

