/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.Notification;
import javax.slee.ServiceID;
import javax.slee.management.ServiceManagementMBean;
import javax.slee.management.ServiceState;
import javax.slee.management.VendorExtensionUtils;
import javax.slee.management.VendorExtensions;

public final class ServiceStateChangeNotification
extends Notification
implements VendorExtensions {
    private final ServiceID service;
    private final ServiceState newState;
    private final ServiceState oldState;
    private static volatile boolean vendorDataSerializationEnabled = false;
    private static volatile boolean vendorDataDeserializationEnabled = false;
    private transient Object vendorData;

    public ServiceStateChangeNotification(ServiceManagementMBean serviceManagementMBean, ServiceID service, ServiceState newState, ServiceState oldState, long sequenceNumber) throws NullPointerException {
        super("javax.slee.management.servicestatechange", serviceManagementMBean, sequenceNumber, System.currentTimeMillis(), service + " state changed from " + oldState + " to " + newState);
        if (serviceManagementMBean == null) {
            throw new NullPointerException("serviceManagementMBean is null");
        }
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        if (newState == null) {
            throw new NullPointerException("newState is null");
        }
        if (oldState == null) {
            throw new NullPointerException("oldState is null");
        }
        this.service = service;
        this.newState = newState;
        this.oldState = oldState;
    }

    public ServiceID getService() {
        return this.service;
    }

    public ServiceState getNewState() {
        return this.newState;
    }

    public ServiceState getOldState() {
        return this.oldState;
    }

    public static void enableVendorDataSerialization() {
        vendorDataSerializationEnabled = true;
    }

    public static void disableVendorDataSerialization() {
        vendorDataSerializationEnabled = false;
    }

    public static void enableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = true;
    }

    public static void disableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = false;
    }

    public void setVendorData(Object vendorData) {
        this.vendorData = vendorData;
    }

    public Object getVendorData() {
        return this.vendorData;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ServiceStateChangeNotification[timestamp=").append(this.getTimeStamp()).append(",service=").append(this.service).append(",old state=").append(this.oldState).append(",new state=").append(this.newState);
        if (this.vendorData != null) {
            buf.append(",vendor data=").append(this.vendorData);
        }
        buf.append("]");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        VendorExtensionUtils.writeObject(out, vendorDataSerializationEnabled ? this.vendorData : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.vendorData = VendorExtensionUtils.readObject(in, vendorDataDeserializationEnabled);
    }
}

