/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.slee.facilities.Level;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.TraceNotification;

public class TraceLevelFilter
implements NotificationFilter {
    private final Level minLevel_10;
    private final TraceLevel minLevel_11;

    public TraceLevelFilter(Level minLevel) {
        this.minLevel_10 = minLevel;
        this.minLevel_11 = null;
    }

    public TraceLevelFilter(TraceLevel minLevel) {
        this.minLevel_10 = null;
        this.minLevel_11 = minLevel;
    }

    public boolean isNotificationEnabled(Notification notification) {
        if (!(notification instanceof TraceNotification)) {
            return false;
        }
        if (this.minLevel_10 != null) {
            Level traceLevel = ((TraceNotification)notification).getLevel();
            return traceLevel != null && !this.minLevel_10.isHigherLevel(traceLevel);
        }
        TraceLevel traceLevel = ((TraceNotification)notification).getTraceLevel();
        return traceLevel != null && !this.minLevel_11.isHigherLevel(traceLevel);
    }
}

