/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.profile.query;

import java.util.ArrayList;
import javax.slee.profile.query.Not;
import javax.slee.profile.query.QueryExpression;

public abstract class CompositeQueryExpression
extends QueryExpression {
    private final ArrayList exprs = new ArrayList();

    public final QueryExpression[] getExpressions() {
        return this.exprs.toArray(new QueryExpression[this.exprs.size()]);
    }

    protected final void add(QueryExpression expr) throws NullPointerException, IllegalArgumentException {
        if (expr == null) {
            throw new NullPointerException("expr is null");
        }
        if (expr instanceof CompositeQueryExpression) {
            ((CompositeQueryExpression)expr).checkForCycles(this);
        } else if (expr instanceof Not) {
            ((Not)expr).checkForCycles(this);
        }
        this.exprs.add(expr);
    }

    void checkForCycles(QueryExpression expr) throws IllegalArgumentException {
        if (expr == this) {
            throw new IllegalArgumentException("Cyclic expression detected");
        }
        for (int i = 0; i < this.exprs.size(); ++i) {
            QueryExpression nested = (QueryExpression)this.exprs.get(i);
            if (nested instanceof CompositeQueryExpression) {
                ((CompositeQueryExpression)nested).checkForCycles(expr);
                continue;
            }
            if (!(nested instanceof Not)) continue;
            ((Not)nested).checkForCycles(expr);
        }
    }
}

