/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;
import org.jboss.mx.util.MetaDataUtil;

public class MBeanOperationInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6178860474881375330L;
    public static final int INFO = 0;
    public static final int ACTION = 1;
    public static final int ACTION_INFO = 2;
    public static final int UNKNOWN = 3;
    private int impact = 3;
    private MBeanParameterInfo[] signature = null;
    private String type = null;
    private transient String cacheString;
    private transient int cacheHashCode;

    public MBeanOperationInfo(String description, Method method) throws IllegalArgumentException {
        super(method.getName(), description);
        this.type = method.getReturnType().getName();
        Class<?>[] sign = method.getParameterTypes();
        this.signature = new MBeanParameterInfo[sign.length];
        for (int i = 0; i < sign.length; ++i) {
            String name = sign[i].getName();
            this.signature[i] = new MBeanParameterInfo(name, name, "MBean Operation Parameter.");
        }
    }

    public MBeanOperationInfo(String name, String description, MBeanParameterInfo[] inSignature, String returnType, int impact) throws IllegalArgumentException {
        super(name, description);
        if (!MetaDataUtil.isValidJavaType((String)returnType)) {
            throw new IllegalArgumentException("Return type is not a valid java identifier (or is reserved): " + returnType);
        }
        if (impact != 0 && impact != 1 && impact != 2 && impact != 3) {
            throw new IllegalArgumentException("Impact is invalid: " + impact);
        }
        this.signature = null == inSignature ? new MBeanParameterInfo[]{} : (MBeanParameterInfo[])inSignature.clone();
        this.type = returnType;
        this.impact = impact;
    }

    public String getReturnType() {
        return this.type;
    }

    public MBeanParameterInfo[] getSignature() {
        return (MBeanParameterInfo[])this.signature.clone();
    }

    public int getImpact() {
        return this.impact;
    }

    public boolean equals(Object object) {
        MBeanParameterInfo[] otherParams;
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof MBeanOperationInfo)) {
            return false;
        }
        MBeanOperationInfo other = (MBeanOperationInfo)object;
        if (!super.equals(other)) {
            return false;
        }
        if (!this.getReturnType().equals(other.getReturnType())) {
            return false;
        }
        if (this.getImpact() != other.getImpact()) {
            return false;
        }
        MBeanParameterInfo[] thisParams = this.getSignature();
        if (thisParams.length != (otherParams = other.getSignature()).length) {
            return false;
        }
        for (int i = 0; i < thisParams.length; ++i) {
            if (thisParams[i].equals(otherParams[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.cacheHashCode == 0) {
            this.cacheHashCode = super.hashCode();
            this.cacheHashCode += this.getReturnType().hashCode();
            this.cacheHashCode += this.impact;
        }
        return this.cacheHashCode;
    }

    public String toString() {
        if (this.cacheString == null) {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(this.getClass().getName()).append(":");
            buffer.append(" name=").append(this.getName());
            buffer.append(" description=").append(this.getDescription());
            buffer.append(" signature=").append(Arrays.asList(this.signature));
            buffer.append(" returnType=").append(this.getReturnType());
            buffer.append(" impact=");
            switch (this.impact) {
                case 1: {
                    buffer.append("ACTION");
                    break;
                }
                case 2: {
                    buffer.append("ACTION_INFO");
                    break;
                }
                case 0: {
                    buffer.append("INFO");
                    break;
                }
                default: {
                    buffer.append("UNKNOWN");
                }
            }
            this.cacheString = buffer.toString();
        }
        return this.cacheString;
    }

    public synchronized Object clone() {
        MBeanOperationInfo clone = null;
        try {
            clone = (MBeanOperationInfo)super.clone();
            clone.signature = (MBeanParameterInfo[])this.signature.clone();
            clone.type = this.type;
            clone.impact = this.impact;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

