/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import org.jboss.mx.server.ObjectInputStreamWithClassLoader;

public class SerializationHelper {
    public static Object deserialize(byte[] byteArray) throws IOException, ClassNotFoundException {
        return SerializationHelper.deserialize(byteArray, Thread.currentThread().getContextClassLoader());
    }

    public static Object deserialize(byte[] byteArray, ClassLoader cl) throws IOException, ClassNotFoundException {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length == 0) {
            return null;
        }
        try {
            if (cl == null) {
                cl = SerializationHelper.class.getClassLoader();
            }
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(byteArray);
            ObjectInputStreamWithClassLoader objectinputstream = new ObjectInputStreamWithClassLoader(bytearrayinputstream, cl);
            Object obj = objectinputstream.readObject();
            return obj;
        }
        catch (OptionalDataException optionaldataexception) {
            throw new IOException(optionaldataexception.getMessage());
        }
    }

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        ObjectOutputStream objectoutputstream = new ObjectOutputStream(bytearrayoutputstream);
        objectoutputstream.writeObject(obj);
        return bytearrayoutputstream.toByteArray();
    }
}

