/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil2;

import java.net.InetAddress;
import java.util.Properties;
import javax.jms.JMSException;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILFactory;
import org.jboss.mq.il.uil2.UILClientILService;
import org.jboss.mq.il.uil2.UILServerIL;

public class UILServerILFactory
implements ServerILFactory {
    public static final String SERVER_IL_FACTORY = UILServerILFactory.class.getName();
    public static final String CLIENT_IL_SERVICE = UILClientILService.class.getName();
    public static final String UIL_ADDRESS_KEY = "UIL_ADDRESS_KEY";
    public static final String UIL_PORT_KEY = "UIL_PORT_KEY";
    public static final String UIL_TCPNODELAY_KEY = "UIL_TCPNODELAY_KEY";
    public static final String UIL_BUFFERSIZE_KEY = "UIL_BUFFERSIZE_KEY";
    public static final String UIL_CHUNKSIZE_KEY = "UIL_CHUNKSIZE_KEY";
    public static final String UIL_RECEIVE_REPLIES_KEY = "UIL_RECEIVE_REPLIES_KEY";
    private ServerIL serverIL;

    public void init(Properties props) throws Exception {
        String t = props.getProperty(UIL_ADDRESS_KEY);
        if (t == null) {
            throw new JMSException("A required connection property was not set: UIL_ADDRESS_KEY");
        }
        InetAddress address = InetAddress.getByName(t);
        t = props.getProperty(UIL_PORT_KEY);
        if (t == null) {
            throw new JMSException("A required connection property was not set: UIL_PORT_KEY");
        }
        int port = Integer.parseInt(t);
        boolean enableTcpNoDelay = false;
        t = props.getProperty(UIL_TCPNODELAY_KEY);
        if (t != null) {
            enableTcpNoDelay = t.equals("yes");
        }
        int bufferSize = 1;
        t = props.getProperty(UIL_BUFFERSIZE_KEY);
        if (t != null) {
            bufferSize = Integer.parseInt(t);
        }
        int chunkSize = 0x40000000;
        t = props.getProperty(UIL_CHUNKSIZE_KEY);
        if (t != null) {
            chunkSize = Integer.parseInt(t);
        }
        String clientSocketFactoryName = null;
        this.serverIL = new UILServerIL(address, port, clientSocketFactoryName, enableTcpNoDelay, bufferSize, chunkSize);
    }

    public ServerIL getServerIL() throws Exception {
        return this.serverIL;
    }
}

