/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.util;

import java.util.Collection;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;

public class IteratorHelper
implements NodeIterator,
PropertyIterator,
NodeTypeIterator {
    static final long UNDETERMINED_SIZE = -1L;
    private final Iterator iter;
    private long size;
    private long pos;

    public IteratorHelper(Collection c) {
        this(c.iterator());
        this.size = c.size();
    }

    public IteratorHelper(Iterator iter) {
        this.iter = iter;
        this.pos = 0L;
        this.size = -1L;
    }

    public void skip(long skipNum) {
        while (skipNum-- > 0L) {
            this.next();
        }
    }

    public long getSize() {
        return this.size;
    }

    public long getPosition() {
        return this.pos;
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public Object next() {
        Object obj = this.iter.next();
        ++this.pos;
        return obj;
    }

    public void remove() {
        this.iter.remove();
    }

    public Node nextNode() {
        return (Node)this.next();
    }

    public Property nextProperty() {
        return (Property)this.next();
    }

    public NodeType nextNodeType() {
        return (NodeType)this.next();
    }
}

