/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRuntimeException;
import org.apache.jackrabbit.rmi.remote.RemoteNodeDefinition;
import org.apache.jackrabbit.rmi.remote.RemoteNodeType;
import org.apache.jackrabbit.rmi.value.SerialValueFactory;

public class ClientNodeType
extends ClientObject
implements NodeType {
    private RemoteNodeType remote;

    public ClientNodeType(RemoteNodeType remote, LocalAdapterFactory factory) {
        super(factory);
        this.remote = remote;
    }

    public String getName() {
        try {
            return this.remote.getName();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isMixin() {
        try {
            return this.remote.isMixin();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean hasOrderableChildNodes() {
        try {
            return this.remote.hasOrderableChildNodes();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeType[] getSupertypes() {
        try {
            return this.getNodeTypeArray(this.remote.getSupertypes());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeType[] getDeclaredSupertypes() {
        try {
            return this.getNodeTypeArray(this.remote.getDeclaredSupertypes());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isNodeType(String type) {
        try {
            return this.remote.isNodeType(type);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        try {
            return this.getPropertyDefArray(this.remote.getPropertyDefs());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        try {
            return this.getPropertyDefArray(this.remote.getDeclaredPropertyDefs());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        try {
            RemoteNodeDefinition[] defs = this.remote.getChildNodeDefs();
            return this.getNodeDefArray(defs);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        try {
            RemoteNodeDefinition[] defs = this.remote.getDeclaredChildNodeDefs();
            return this.getNodeDefArray(defs);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canSetProperty(String name, Value value) {
        try {
            return this.remote.canSetProperty(name, SerialValueFactory.makeSerialValue(value));
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canSetProperty(String name, Value[] values) {
        try {
            Value[] serials = SerialValueFactory.makeSerialValueArray(values);
            return this.remote.canSetProperty(name, serials);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canAddChildNode(String name) {
        try {
            return this.remote.canAddChildNode(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canAddChildNode(String name, String type) {
        try {
            return this.remote.canAddChildNode(name, type);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canRemoveItem(String name) {
        try {
            return this.remote.canRemoveItem(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public String getPrimaryItemName() {
        try {
            return this.remote.getPrimaryItemName();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }
}

