/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.iterator.ArrayEventListenerIterator;
import org.apache.jackrabbit.rmi.observation.ClientEventPoll;
import org.apache.jackrabbit.rmi.remote.RemoteObservationManager;

public class ClientObservationManager
extends ClientObject
implements ObservationManager {
    private final RemoteObservationManager remote;
    private final Workspace workspace;
    private ClientEventPoll poller;

    public ClientObservationManager(Workspace workspace, RemoteObservationManager remote) {
        super(null);
        this.remote = remote;
        this.workspace = workspace;
    }

    public void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName, boolean noLocal) throws RepositoryException {
        try {
            long listenerId = this.getClientEventPoll().addListener(listener);
            this.remote.addEventListener(listenerId, eventTypes, absPath, isDeep, uuid, nodeTypeName, noLocal);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void removeEventListener(EventListener listener) throws RepositoryException {
        try {
            long id = this.getClientEventPoll().removeListener(listener);
            this.remote.removeEventListener(id);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public EventListenerIterator getRegisteredEventListeners() {
        return new ArrayEventListenerIterator(this.poller.getListeners());
    }

    private synchronized ClientEventPoll getClientEventPoll() {
        if (this.poller == null) {
            this.poller = new ClientEventPoll(this.remote, this.workspace.getSession());
            this.poller.start();
        }
        return this.poller;
    }
}

