/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.rmi.remote.RemoteItem;
import org.apache.jackrabbit.rmi.remote.RemoteNode;
import org.apache.jackrabbit.rmi.remote.RemoteNodeDefinition;
import org.apache.jackrabbit.rmi.remote.RemoteNodeType;
import org.apache.jackrabbit.rmi.remote.RemoteProperty;
import org.apache.jackrabbit.rmi.remote.RemotePropertyDefinition;
import org.apache.jackrabbit.rmi.remote.RemoteRow;
import org.apache.jackrabbit.rmi.remote.RemoteVersion;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;

public class ServerObject
extends UnicastRemoteObject {
    private RemoteAdapterFactory factory;

    protected ServerObject(RemoteAdapterFactory factory) throws RemoteException {
        this.factory = factory;
    }

    protected RemoteAdapterFactory getFactory() {
        return this.factory;
    }

    protected RepositoryException getRepositoryException(RepositoryException ex) {
        if (ex instanceof AccessDeniedException) {
            return new AccessDeniedException(ex.getMessage());
        }
        if (ex instanceof ConstraintViolationException) {
            return new ConstraintViolationException(ex.getMessage());
        }
        if (ex instanceof InvalidItemStateException) {
            return new InvalidItemStateException(ex.getMessage());
        }
        if (ex instanceof InvalidQueryException) {
            return new InvalidQueryException(ex.getMessage());
        }
        if (ex instanceof InvalidSerializedDataException) {
            return new InvalidSerializedDataException(ex.getMessage());
        }
        if (ex instanceof ItemExistsException) {
            return new ItemExistsException(ex.getMessage());
        }
        if (ex instanceof ItemNotFoundException) {
            return new ItemNotFoundException(ex.getMessage());
        }
        if (ex instanceof LockException) {
            return new LockException(ex.getMessage());
        }
        if (ex instanceof LoginException) {
            return new LoginException(ex.getMessage());
        }
        if (ex instanceof MergeException) {
            return new MergeException(ex.getMessage());
        }
        if (ex instanceof NamespaceException) {
            return new NamespaceException(ex.getMessage());
        }
        if (ex instanceof NoSuchNodeTypeException) {
            return new NoSuchNodeTypeException(ex.getMessage());
        }
        if (ex instanceof NoSuchWorkspaceException) {
            return new NoSuchWorkspaceException(ex.getMessage());
        }
        if (ex instanceof PathNotFoundException) {
            return new PathNotFoundException(ex.getMessage());
        }
        if (ex instanceof ReferentialIntegrityException) {
            return new ReferentialIntegrityException(ex.getMessage());
        }
        if (ex instanceof UnsupportedRepositoryOperationException) {
            return new UnsupportedRepositoryOperationException(ex.getMessage());
        }
        if (ex instanceof ValueFormatException) {
            return new ValueFormatException(ex.getMessage());
        }
        if (ex instanceof VersionException) {
            return new VersionException(ex.getMessage());
        }
        return new RepositoryException(ex.getMessage());
    }

    protected RemoteItem getRemoteItem(Item item) throws RemoteException {
        if (item instanceof Property) {
            return this.factory.getRemoteProperty((Property)item);
        }
        if (item instanceof Node) {
            return this.getRemoteNode((Node)item);
        }
        return this.factory.getRemoteItem(item);
    }

    protected RemoteNode getRemoteNode(Node node) throws RemoteException {
        if (node instanceof Version) {
            return this.factory.getRemoteVersion((Version)node);
        }
        if (node instanceof VersionHistory) {
            return this.factory.getRemoteVersionHistory((VersionHistory)node);
        }
        return this.factory.getRemoteNode(node);
    }

    protected RemoteProperty[] getRemotePropertyArray(PropertyIterator iterator) throws RemoteException {
        if (iterator != null) {
            ArrayList<RemoteProperty> remotes = new ArrayList<RemoteProperty>();
            while (iterator.hasNext()) {
                remotes.add(this.factory.getRemoteProperty(iterator.nextProperty()));
            }
            return remotes.toArray(new RemoteProperty[remotes.size()]);
        }
        return new RemoteProperty[0];
    }

    protected RemoteNode[] getRemoteNodeArray(NodeIterator iterator) throws RemoteException {
        if (iterator != null) {
            ArrayList<RemoteNode> remotes = new ArrayList<RemoteNode>();
            while (iterator.hasNext()) {
                remotes.add(this.getRemoteNode(iterator.nextNode()));
            }
            return remotes.toArray(new RemoteNode[remotes.size()]);
        }
        return new RemoteNode[0];
    }

    protected RemoteVersion[] getRemoteVersionArray(Version[] versions) throws RemoteException {
        if (versions != null) {
            RemoteVersion[] remotes = new RemoteVersion[versions.length];
            for (int i = 0; i < remotes.length; ++i) {
                remotes[i] = this.factory.getRemoteVersion(versions[i]);
            }
            return remotes;
        }
        return new RemoteVersion[0];
    }

    protected RemoteVersion[] getRemoteVersionArray(VersionIterator iterator) throws RemoteException {
        if (iterator != null) {
            ArrayList<RemoteVersion> remotes = new ArrayList<RemoteVersion>();
            while (iterator.hasNext()) {
                remotes.add(this.factory.getRemoteVersion(iterator.nextVersion()));
            }
            return remotes.toArray(new RemoteVersion[remotes.size()]);
        }
        return new RemoteVersion[0];
    }

    protected RemoteNodeType[] getRemoteNodeTypeArray(NodeType[] types) throws RemoteException {
        if (types != null) {
            RemoteNodeType[] remotes = new RemoteNodeType[types.length];
            for (int i = 0; i < types.length; ++i) {
                remotes[i] = this.factory.getRemoteNodeType(types[i]);
            }
            return remotes;
        }
        return new RemoteNodeType[0];
    }

    protected RemoteNodeType[] getRemoteNodeTypeArray(NodeTypeIterator iterator) throws RemoteException {
        if (iterator != null) {
            ArrayList<RemoteNodeType> remotes = new ArrayList<RemoteNodeType>();
            while (iterator.hasNext()) {
                remotes.add(this.factory.getRemoteNodeType(iterator.nextNodeType()));
            }
            return remotes.toArray(new RemoteNodeType[remotes.size()]);
        }
        return new RemoteNodeType[0];
    }

    protected RemoteNodeDefinition[] getRemoteNodeDefArray(NodeDefinition[] defs) throws RemoteException {
        if (defs != null) {
            RemoteNodeDefinition[] remotes = new RemoteNodeDefinition[defs.length];
            for (int i = 0; i < defs.length; ++i) {
                remotes[i] = this.factory.getRemoteNodeDefinition(defs[i]);
            }
            return remotes;
        }
        return new RemoteNodeDefinition[0];
    }

    protected RemotePropertyDefinition[] getRemotePropertyDefArray(PropertyDefinition[] defs) throws RemoteException {
        if (defs != null) {
            RemotePropertyDefinition[] remotes = new RemotePropertyDefinition[defs.length];
            for (int i = 0; i < defs.length; ++i) {
                remotes[i] = this.factory.getRemotePropertyDefinition(defs[i]);
            }
            return remotes;
        }
        return new RemotePropertyDefinition[0];
    }

    protected RemoteRow[] getRemoteRowArray(RowIterator iterator) throws RemoteException {
        if (iterator != null) {
            ArrayList<RemoteRow> remotes = new ArrayList<RemoteRow>();
            while (iterator.hasNext()) {
                remotes.add(this.getFactory().getRemoteRow(iterator.nextRow()));
            }
            return remotes.toArray(new RemoteRow[remotes.size()]);
        }
        return new RemoteRow[0];
    }
}

