/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.rmi.remote.RemoteVersion;
import org.apache.jackrabbit.rmi.remote.RemoteVersionHistory;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerNode;

public class ServerVersionHistory
extends ServerNode
implements RemoteVersionHistory {
    private VersionHistory versionHistory;

    public ServerVersionHistory(VersionHistory versionHistory, RemoteAdapterFactory factory) throws RemoteException {
        super((Node)versionHistory, factory);
        this.versionHistory = versionHistory;
    }

    public RemoteVersion getRootVersion() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersion(this.versionHistory.getRootVersion());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteVersion[] getAllVersions() throws RepositoryException, RemoteException {
        try {
            return this.getRemoteVersionArray(this.versionHistory.getAllVersions());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteVersion getVersion(String versionName) throws RepositoryException, RemoteException {
        try {
            Version version = this.versionHistory.getVersion(versionName);
            return this.getFactory().getRemoteVersion(version);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteVersion getVersionByLabel(String label) throws RepositoryException, RemoteException {
        try {
            Version version = this.versionHistory.getVersionByLabel(label);
            return this.getFactory().getRemoteVersion(version);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void addVersionLabel(String versionName, String label, boolean moveLabel) throws RepositoryException, RemoteException {
        try {
            this.versionHistory.addVersionLabel(versionName, label, moveLabel);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void removeVersionLabel(String label) throws RepositoryException, RemoteException {
        try {
            this.versionHistory.removeVersionLabel(label);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public boolean hasVersionLabel(String label) throws RepositoryException, RemoteException {
        return this.versionHistory.hasVersionLabel(label);
    }

    public boolean hasVersionLabel(String versionUUID, String label) throws RepositoryException, RemoteException {
        try {
            Version version = this.getVersionByUUID(versionUUID);
            return this.versionHistory.hasVersionLabel(version, label);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public String[] getVersionLabels() throws RepositoryException, RemoteException {
        return this.versionHistory.getVersionLabels();
    }

    public String[] getVersionLabels(String versionUUID) throws RepositoryException, RemoteException {
        try {
            Version version = this.getVersionByUUID(versionUUID);
            return this.versionHistory.getVersionLabels(version);
        }
        catch (ClassCastException cce) {
            throw this.getRepositoryException(new RepositoryException((Throwable)cce));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void removeVersion(String versionName) throws RepositoryException, RemoteException {
        try {
            this.versionHistory.removeVersion(versionName);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public String getVersionableUUID() throws RepositoryException, RemoteException {
        return this.versionHistory.getVersionableUUID();
    }
}

