/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.io.IOException;
import java.util.Properties;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class DavException
extends Exception {
    private static Logger log = Logger.getLogger(DavException.class);
    private static Properties statusPhrases = new Properties();
    private static final String XML_ERROR = "error";
    private int errorCode = 500;
    private Element conditionElement;

    public DavException(int errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
        log.debug((Object)("DavException: (" + errorCode + ") " + message));
    }

    public DavException(int errorCode) {
        this(errorCode, statusPhrases.getProperty(String.valueOf(errorCode)));
    }

    public DavException(int errorCode, String message, Element conditionElement) {
        this(errorCode, message);
        this.conditionElement = conditionElement;
        log.debug((Object)("DavException: (" + errorCode + ") " + conditionElement.toString()));
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Element getError() {
        Element error = new Element(XML_ERROR, DavConstants.NAMESPACE);
        if (this.conditionElement != null) {
            error.addContent((Content)this.conditionElement);
        }
        return error;
    }

    public String getStatusPhrase() {
        return DavException.getStatusPhrase(this.errorCode);
    }

    public static String getStatusPhrase(int errorCode) {
        return statusPhrases.getProperty(errorCode + "");
    }

    static {
        try {
            statusPhrases.load(DavException.class.getResourceAsStream("statuscode.properties"));
        }
        catch (IOException e) {
            log.error((Object)("Failed to load status properties: " + e.getMessage()));
        }
    }
}

