/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class MultiStatus
implements DavConstants {
    private ArrayList responses = new ArrayList();
    private String responseDescription;

    public void addResourceProperties(DavResource resource, DavPropertyNameSet propNameSet, int propFindType, int depth) {
        this.addResponse(new MultiStatusResponse(resource, propNameSet, propFindType));
        if (depth > 0) {
            DavResourceIterator iter = resource.getMembers();
            while (iter.hasNext()) {
                this.addResourceProperties(iter.nextResource(), propNameSet, propFindType, depth - 1);
            }
        }
    }

    public void addResourceProperties(DavResource resource, DavPropertyNameSet propNameSet, int depth) {
        this.addResourceProperties(resource, propNameSet, 0, depth);
    }

    public void addResourceStatus(DavResource resource, int status, int depth) {
        this.addResponse(new MultiStatusResponse(resource.getHref(), status));
        if (depth > 0) {
            DavResourceIterator iter = resource.getMembers();
            while (iter.hasNext()) {
                this.addResourceStatus(iter.nextResource(), status, depth - 1);
            }
        }
    }

    public void addResponse(MultiStatusResponse response) {
        this.responses.add(response);
    }

    public MultiStatusResponse[] getResponses() {
        return this.responses.toArray(new MultiStatusResponse[this.responses.size()]);
    }

    public void setResponseDescription(String responseDescription) {
        this.responseDescription = responseDescription;
    }

    public String getResponseDescription() {
        return this.responseDescription;
    }

    public Document toXml() {
        Element multistatus = new Element("multistatus", NAMESPACE);
        Iterator it = this.responses.iterator();
        while (it.hasNext()) {
            multistatus.addContent((Content)((MultiStatusResponse)it.next()).toXml());
        }
        if (this.responseDescription != null) {
            multistatus.addContent((Content)new Element("responsedescription", NAMESPACE).setText(this.responseDescription));
        }
        return new Document(multistatus);
    }

    public static MultiStatus createFromXml(Document multistatusDocument) {
        if (multistatusDocument == null) {
            throw new IllegalArgumentException("Cannot create a MultiStatus object from a null xml document.");
        }
        Element msElem = multistatusDocument.getRootElement();
        if (!"multistatus".equals(msElem.getName()) || !NAMESPACE.equals((Object)msElem.getNamespace())) {
            throw new IllegalArgumentException("DAV:multistatus element expected.");
        }
        MultiStatus multistatus = new MultiStatus();
        List respList = msElem.getChildren("response", NAMESPACE);
        Iterator it = respList.iterator();
        while (it.hasNext()) {
            MultiStatusResponse response = MultiStatusResponse.createFromXml((Element)it.next());
            multistatus.addResponse(response);
        }
        multistatus.setResponseDescription(msElem.getChildText("responsedescription", NAMESPACE));
        return multistatus;
    }
}

