/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.util.Collection;
import java.util.HashMap;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.util.XmlUtil;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class MultiStatusResponse
implements DavConstants {
    private static Logger log = Logger.getLogger(MultiStatusResponse.class);
    private final String href;
    private final Element status200;
    private final Element status404;
    private final HashMap statusMap;
    private String responseDescription;

    public MultiStatusResponse(String href) {
        this.statusMap = new HashMap();
        this.href = href;
        this.status200 = new Element("prop", NAMESPACE);
        this.status404 = new Element("prop", NAMESPACE);
        this.statusMap.put(new Integer(200), this.status200);
        this.statusMap.put(new Integer(404), this.status404);
    }

    public MultiStatusResponse(DavResource resource, DavPropertyNameSet propNameSet) {
        this(resource, propNameSet, 0);
    }

    public MultiStatusResponse(DavResource resource, DavPropertyNameSet propNameSet, int propFindType) {
        block4: {
            block3: {
                this(resource.getHref());
                if (propFindType != 2) break block3;
                DavPropertyName[] propNames = resource.getPropertyNames();
                for (int i = 0; i < propNames.length; ++i) {
                    this.status200.addContent((Content)propNames[i].toXml());
                }
                break block4;
            }
            propNameSet = new DavPropertyNameSet((Collection)propNameSet);
            DavPropertyIterator iter = resource.getProperties().iterator();
            while (iter.hasNext()) {
                DavProperty wdp = iter.nextProperty();
                if ((propFindType != 1 || wdp.isProtected()) && !propNameSet.remove(wdp.getName())) continue;
                this.status200.addContent((Content)wdp.toXml());
            }
            if (propFindType == 1) break block4;
            for (DavPropertyName propName : propNameSet) {
                this.status404.addContent((Content)propName.toXml());
            }
        }
    }

    public MultiStatusResponse(String href, int status) {
        this(href);
        this.statusMap.put(new Integer(status), new Element(null));
    }

    public String getHref() {
        return this.href;
    }

    private void add(Element propertyElem, int status) {
        Integer statusKey = new Integer(status);
        Element propsContainer = (Element)this.statusMap.get(statusKey);
        if (propsContainer == null) {
            propsContainer = new Element("prop", NAMESPACE);
            this.statusMap.put(statusKey, propsContainer);
        }
        propsContainer.addContent(propertyElem.detach());
    }

    public void add(DavProperty property) {
        this.status200.addContent((Content)property.toXml());
    }

    public void add(DavPropertyName propertyName) {
        this.status200.addContent((Content)propertyName.toXml());
    }

    public void add(DavProperty property, int status) {
        this.add(property.toXml(), status);
    }

    public void add(DavPropertyName propertyName, int status) {
        this.add(propertyName.toXml(), status);
    }

    public DavPropertySet getProperties(int status) {
        Element propElem;
        DavPropertySet set = new DavPropertySet();
        Integer key = new Integer(status);
        if (this.statusMap.containsKey(key) && (propElem = (Element)this.statusMap.get(key)) != null) {
            for (Element propEntry : propElem.getChildren()) {
                DefaultDavProperty prop = DefaultDavProperty.createFromXml(propEntry);
                set.add(prop);
            }
        }
        return set;
    }

    public DavPropertyNameSet getPropertyNames(int status) {
        Element propElem;
        DavPropertyNameSet set = new DavPropertyNameSet();
        Integer key = new Integer(status);
        if (this.statusMap.containsKey(key) && (propElem = (Element)this.statusMap.get(key)) != null) {
            for (Element propEntry : propElem.getChildren()) {
                set.add(DavPropertyName.createFromXml(propEntry));
            }
        }
        return set;
    }

    public String getResponseDescription() {
        return this.responseDescription;
    }

    public void setResponseDescription(String responseDescription) {
        this.responseDescription = responseDescription;
    }

    public Element toXml() {
        if ("".equals(this.href)) {
            return null;
        }
        Element response = new Element("response", NAMESPACE);
        response.addContent((Content)XmlUtil.hrefToXml(this.href));
        for (Integer statusKey : this.statusMap.keySet()) {
            Element prop = (Element)this.statusMap.get(statusKey);
            if (prop == null) continue;
            Status status = new Status(statusKey);
            if ("prop".equals(prop.getName())) {
                if (prop.getContentSize() <= 0) continue;
                Element propstat = new Element("propstat", NAMESPACE);
                propstat.addContent((Content)prop);
                propstat.addContent((Content)status.toXml());
                response.addContent((Content)propstat);
                continue;
            }
            response.addContent((Content)status.toXml());
        }
        if (this.responseDescription != null) {
            Element desc = new Element("responsedescription", NAMESPACE);
            desc.setText(this.responseDescription);
            response.addContent((Content)desc);
        }
        return response;
    }

    public static MultiStatusResponse createFromXml(Element responseElement) {
        if (responseElement == null) {
            throw new IllegalArgumentException("The response element must not be null.");
        }
        String href = responseElement.getChildText("href", NAMESPACE);
        String statusLine = responseElement.getChildText("status", NAMESPACE);
        MultiStatusResponse response = statusLine != null ? new MultiStatusResponse(href, Status.createFromStatusLine(statusLine).getStatusCode()) : new MultiStatusResponse(href);
        for (Element propstat : responseElement.getChildren("propstat", NAMESPACE)) {
            Element prop = propstat.getChild("prop", NAMESPACE);
            String propstatus = propstat.getChildText("status", NAMESPACE);
            if (propstatus == null) continue;
            Status st = Status.createFromStatusLine(propstatus);
            Element[] propertyElems = prop.getChildren().toArray(new Element[0]);
            for (int i = 0; i < propertyElems.length; ++i) {
                response.add(propertyElems[i], st.getStatusCode());
            }
        }
        response.setResponseDescription(responseElement.getChildText("responsedescription", NAMESPACE));
        return response;
    }

    private static class Status {
        private String version = "HTTP/1.1";
        private int code;
        private String phrase = "";

        private Status(int code) {
            this.code = code;
            this.phrase = DavException.getStatusPhrase(code);
        }

        private Status(String version, int code, String phrase) {
            this.version = version;
            this.code = code;
            this.phrase = phrase;
        }

        private int getStatusCode() {
            return this.code;
        }

        private Element toXml() {
            String statusLine = this.version + " " + this.code + " " + this.phrase;
            return new Element("status", DavConstants.NAMESPACE).setText(statusLine);
        }

        private static Status createFromStatusLine(String statusLine) {
            Status status;
            if (statusLine == null) {
                throw new IllegalArgumentException("Unable to parse status line from null xml element.");
            }
            int length = statusLine.length();
            int at = 0;
            int start = 0;
            try {
                while (Character.isWhitespace(statusLine.charAt(at))) {
                    ++at;
                    ++start;
                }
                if (!"HTTP".equals(statusLine.substring(at, at += 4))) {
                    log.warn((Object)("Status-Line '" + statusLine + "' does not start with HTTP"));
                }
                if ((at = statusLine.indexOf(" ", at)) <= 0) {
                    log.warn((Object)("Unable to parse HTTP-Version from the status line: '" + statusLine + "'"));
                }
                String version = statusLine.substring(start, at).toUpperCase();
                while (statusLine.charAt(at) == ' ') {
                    ++at;
                }
                int to = statusLine.indexOf(" ", at);
                if (to < 0) {
                    to = length;
                }
                try {
                    int code = Integer.parseInt(statusLine.substring(at, to));
                    status = new Status(code);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Unable to parse status code from status line: '" + statusLine + "'");
                }
                String phrase = "";
                at = to + 1;
                if (at < length) {
                    phrase = statusLine.substring(at).trim();
                }
                status.version = version;
                status.phrase = phrase;
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Status-Line '" + statusLine + "' is not valid");
            }
            return status;
        }
    }
}

