/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.observation.EventDiscovery;
import org.apache.jackrabbit.webdav.observation.Subscription;
import org.apache.jackrabbit.webdav.observation.SubscriptionDiscovery;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class WebdavResponseImpl
implements WebdavResponse {
    private static Logger log = Logger.getLogger(WebdavResponseImpl.class);
    private HttpServletResponse httpResponse;

    public WebdavResponseImpl(HttpServletResponse httpResponse) {
        this.httpResponse = httpResponse;
        this.addHeader("Pragma", "No-cache");
        this.addHeader("Cache-Control", "no-cache");
    }

    public void sendErrorResponse(DavException exception) throws IOException {
        Element errorElem = exception.getError();
        if (errorElem == null || errorElem.getChildren().size() == 0) {
            this.httpResponse.sendError(exception.getErrorCode(), exception.getStatusPhrase());
        } else {
            this.sendXmlResponse(new Document(exception.getError()), exception.getErrorCode());
        }
    }

    public void sendMultiStatusResponse(MultiStatus multistatus) throws IOException {
        this.sendXmlResponse(multistatus.toXml(), 207);
    }

    public void sendLockResponse(ActiveLock lock) throws IOException {
        this.httpResponse.setHeader("Lock-Token", "<" + lock.getToken() + ">");
        Element propElem = new Element("prop", DavConstants.NAMESPACE);
        propElem.addContent((Content)new LockDiscovery(lock).toXml());
        this.sendXmlResponse(new Document(propElem), 200);
    }

    public void sendRefreshLockResponse(ActiveLock[] locks) throws IOException {
        Element propElem = new Element("prop", DavConstants.NAMESPACE);
        propElem.addContent((Content)new LockDiscovery(locks).toXml());
        this.sendXmlResponse(new Document(propElem), 200);
    }

    public void sendXmlResponse(Document xmlDoc, int status) throws IOException {
        this.httpResponse.setStatus(status);
        if (xmlDoc != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLOutputter xmli = new XMLOutputter(Format.getRawFormat());
            xmli.output(xmlDoc, (OutputStream)out);
            byte[] bytes = out.toByteArray();
            this.httpResponse.setContentType("text/xml; charset=UTF-8");
            this.httpResponse.setContentLength(bytes.length);
            this.httpResponse.getOutputStream().write(bytes);
            out.close();
            out.flush();
        }
    }

    public void sendSubscriptionResponse(Subscription subscription) throws IOException {
        Element propElem = new Element("prop", DavConstants.NAMESPACE);
        propElem.addContent((Content)new SubscriptionDiscovery(subscription).toXml());
        Document doc = new Document(propElem);
        this.sendXmlResponse(doc, 200);
    }

    public void sendPollResponse(EventDiscovery eventDiscovery) throws IOException {
        Document pollDoc = new Document(eventDiscovery.toXml());
        this.sendXmlResponse(pollDoc, 200);
    }

    public void addCookie(Cookie cookie) {
        this.httpResponse.addCookie(cookie);
    }

    public boolean containsHeader(String s) {
        return this.httpResponse.containsHeader(s);
    }

    public String encodeURL(String s) {
        return this.httpResponse.encodeRedirectURL(s);
    }

    public String encodeRedirectURL(String s) {
        return this.httpResponse.encodeRedirectURL(s);
    }

    public String encodeUrl(String s) {
        return this.httpResponse.encodeUrl(s);
    }

    public String encodeRedirectUrl(String s) {
        return this.httpResponse.encodeRedirectURL(s);
    }

    public void sendError(int i, String s) throws IOException {
        this.httpResponse.sendError(i, s);
    }

    public void sendError(int i) throws IOException {
        this.httpResponse.sendError(i);
    }

    public void sendRedirect(String s) throws IOException {
        this.httpResponse.sendRedirect(s);
    }

    public void setDateHeader(String s, long l) {
        this.httpResponse.setDateHeader(s, l);
    }

    public void addDateHeader(String s, long l) {
        this.httpResponse.addDateHeader(s, l);
    }

    public void setHeader(String s, String s1) {
        this.httpResponse.setHeader(s, s1);
    }

    public void addHeader(String s, String s1) {
        this.httpResponse.addHeader(s, s1);
    }

    public void setIntHeader(String s, int i) {
        this.httpResponse.setIntHeader(s, i);
    }

    public void addIntHeader(String s, int i) {
        this.httpResponse.addIntHeader(s, i);
    }

    public void setStatus(int i) {
        this.httpResponse.setStatus(i);
    }

    public void setStatus(int i, String s) {
        this.httpResponse.setStatus(i, s);
    }

    public String getCharacterEncoding() {
        return this.httpResponse.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.httpResponse.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.httpResponse.getWriter();
    }

    public void setContentLength(int i) {
    }

    public void setContentType(String s) {
        this.httpResponse.setContentType(s);
    }

    public void setBufferSize(int i) {
        this.httpResponse.setBufferSize(i);
    }

    public int getBufferSize() {
        return this.httpResponse.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.httpResponse.flushBuffer();
    }

    public void resetBuffer() {
        this.httpResponse.resetBuffer();
    }

    public boolean isCommitted() {
        return this.httpResponse.isCommitted();
    }

    public void reset() {
        this.httpResponse.reset();
    }

    public void setLocale(Locale locale) {
        this.httpResponse.setLocale(locale);
    }

    public Locale getLocale() {
        return this.httpResponse.getLocale();
    }
}

