/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.lock;

import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.util.XmlUtil;
import org.jdom.Content;
import org.jdom.Element;

public abstract class AbstractActiveLock
implements ActiveLock,
DavConstants {
    public Element toXml() {
        Element activeLock = new Element("activelock", NAMESPACE);
        Element property = new Element("locktype", NAMESPACE);
        property.addContent((Content)this.getType().toXml());
        activeLock.addContent((Content)property);
        property = new Element("lockscope", NAMESPACE);
        property.addContent((Content)this.getScope().toXml());
        activeLock.addContent((Content)property);
        activeLock.addContent((Content)XmlUtil.depthToXml(this.isDeep()));
        long timeout = this.getTimeout();
        if (!this.isExpired() && timeout != Long.MIN_VALUE) {
            activeLock.addContent((Content)XmlUtil.timeoutToXml(this.getTimeout()));
        }
        if (this.getOwner() != null) {
            property = new Element("owner", NAMESPACE);
            property.setText(this.getOwner());
            activeLock.addContent((Content)property);
        }
        if (this.getToken() != null) {
            property = new Element("locktoken", NAMESPACE);
            Element href = new Element("href", NAMESPACE);
            href.setText(this.getToken());
            property.addContent((Content)href);
            activeLock.addContent((Content)property);
        }
        return activeLock;
    }
}

