/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.lock;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.DavConstants;
import org.jdom.Element;
import org.jdom.Namespace;

public class Type {
    private static Map types = new HashMap();
    public static final Type WRITE = Type.create("write", DavConstants.NAMESPACE);
    private final String name;
    private final Namespace namespace;

    private Type(String name, Namespace namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public Element toXml() {
        return new Element(this.name, this.namespace);
    }

    public static Type create(Element lockType) {
        if (lockType == null) {
            throw new IllegalArgumentException("'null' is not valid lock type entry.");
        }
        return Type.create(lockType.getName(), lockType.getNamespace());
    }

    public static Type create(String name, Namespace namespace) {
        String key = "{" + namespace.getURI() + "}" + name;
        if (types.containsKey(key)) {
            return (Type)types.get(key);
        }
        Type type = new Type(name, namespace);
        types.put(key, type);
        return type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Type) {
            Type other = (Type)obj;
            return this.name.equals(other.name) && this.namespace.equals((Object)other.namespace);
        }
        return false;
    }
}

