/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.observation;

import java.util.List;
import org.apache.jackrabbit.webdav.observation.ObservationConstants;
import org.apache.jackrabbit.webdav.util.XmlUtil;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class SubscriptionInfo
implements ObservationConstants {
    private static Logger log = Logger.getLogger(SubscriptionInfo.class);
    private Element info;
    private List eventTypes;
    private long timeout;
    private boolean isDeep;

    public SubscriptionInfo(Element reqInfo, long timeout, boolean isDeep) {
        if (!"subscriptioninfo".equals(reqInfo.getName())) {
            throw new IllegalArgumentException("Element with name 'subscriptioninfo' expected");
        }
        if (reqInfo.getChild("eventtype", NAMESPACE) == null) {
            throw new IllegalArgumentException("'subscriptioninfo' must contain an 'eventtype' child element.");
        }
        this.eventTypes = reqInfo.getChild("eventtype", NAMESPACE).getChildren();
        if (this.eventTypes.size() == 0) {
            throw new IllegalArgumentException("'subscriptioninfo' must at least indicate a single event type.");
        }
        this.info = (Element)reqInfo.detach();
        this.isDeep = isDeep;
        this.setTimeOut(timeout);
    }

    public List getEventTypes() {
        return this.eventTypes;
    }

    public String[] getFilters(String name) {
        List li;
        String[] filters = null;
        Element filter = this.info.getChild("filter");
        if (filter != null && !(li = filter.getChildren(name)).isEmpty()) {
            filters = new String[li.size()];
            for (int i = 0; i < filters.length; ++i) {
                filters[i] = ((Element)li.get(i)).getText();
            }
        }
        return filters;
    }

    public boolean isNoLocal() {
        return this.info.getChild("nolocal", NAMESPACE) != null;
    }

    public boolean isDeep() {
        return this.isDeep;
    }

    public long getTimeOut() {
        return this.timeout;
    }

    public void setTimeOut(long timeout) {
        this.timeout = timeout;
    }

    public Element[] toXml() {
        Element[] elems = new Element[]{this.info, XmlUtil.depthToXml(this.isDeep), XmlUtil.timeoutToXml(this.timeout)};
        return elems;
    }
}

