/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.ordering;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.ordering.OrderingConstants;
import org.apache.jackrabbit.webdav.ordering.Position;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class OrderPatch
implements OrderingConstants {
    private static Logger log = Logger.getLogger(OrderPatch.class);
    private Member[] instructions;
    private String orderingType;

    public OrderPatch(Element orderPatchElement) {
        if (!"orderpatch".equals(orderPatchElement.getName()) || orderPatchElement.getChild("ordering-type") == null) {
            throw new IllegalArgumentException("ORDERPATH request body must start with an 'orderpatch' element, which must contain an 'ordering-type' child element.");
        }
        this.orderingType = orderPatchElement.getChild("ordering-type").getChildText("href");
        List oMembers = orderPatchElement.getChildren("order-member", DavConstants.NAMESPACE);
        Iterator it = oMembers.iterator();
        int cnt = 0;
        ArrayList<Member> tmpInst = new ArrayList<Member>();
        while (it.hasNext()) {
            Element member = (Element)it.next();
            try {
                String segment = member.getChildText("segment");
                Position pos = new Position(member.getChild("position"));
                Member om = new Member(segment, pos);
                tmpInst.add(om);
                ++cnt;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Invalid element in 'orderpatch' request body: " + e.getMessage()));
            }
        }
        this.instructions = tmpInst.toArray(new Member[cnt]);
    }

    public OrderPatch(String orderingType, Member[] instructions) {
        this.orderingType = orderingType;
        this.instructions = instructions;
    }

    public String getOrderingType() {
        return this.orderingType;
    }

    public Member[] getOrderInstructions() {
        return this.instructions;
    }

    public class Member {
        private String memberHandle;
        private Position position;

        public Member(String memberHandle, Position position) {
            this.memberHandle = memberHandle;
            this.position = position;
        }

        public String getMemberHandle() {
            return this.memberHandle;
        }

        public Position getPosition() {
            return this.position;
        }
    }
}

