/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class DavPropertyNameSet
extends HashSet {
    private static Logger log = Logger.getLogger(DavPropertyNameSet.class);

    public DavPropertyNameSet() {
    }

    public DavPropertyNameSet(Collection c) {
        super(c);
    }

    public DavPropertyNameSet(Element propElement) {
        if (propElement == null || !propElement.getName().equals("prop")) {
            throw new IllegalArgumentException("'DAV:prop' element expected.");
        }
        List props = propElement.getChildren();
        for (int j = 0; j < props.size(); ++j) {
            Element prop = (Element)props.get(j);
            String propName = prop.getName();
            if (propName == null || "".equals(propName)) continue;
            this.add(DavPropertyName.create(propName, prop.getNamespace()));
        }
    }

    public boolean add(DavPropertyName propertyName) {
        return super.add(propertyName);
    }

    public boolean add(Object o) {
        if (o instanceof DavPropertyName) {
            return this.add((DavPropertyName)o);
        }
        return false;
    }

    public Element toXml() {
        Element prop = new Element("prop", DavConstants.NAMESPACE);
        Iterator it = super.iterator();
        while (it.hasNext()) {
            prop.addContent((Content)((DavPropertyName)it.next()).toXml());
        }
        return prop;
    }
}

