/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.jdom.Namespace;

public class DavPropertySet {
    private final HashMap map = new HashMap();

    public DavProperty add(DavProperty property) {
        return this.map.put(property.getName(), property);
    }

    public void addAll(DavPropertySet pset) {
        this.map.putAll(pset.map);
    }

    public DavProperty get(String name) {
        return this.get(DavPropertyName.create(name));
    }

    public DavProperty get(String name, Namespace namespace) {
        return this.get(DavPropertyName.create(name, namespace));
    }

    public DavProperty get(DavPropertyName name) {
        return (DavProperty)this.map.get(name);
    }

    public DavProperty remove(DavPropertyName name) {
        return (DavProperty)this.map.remove(name);
    }

    public DavProperty remove(String name) {
        return this.remove(DavPropertyName.create(name));
    }

    public DavProperty remove(String name, Namespace namespace) {
        return this.remove(DavPropertyName.create(name, namespace));
    }

    public DavPropertyIterator iterator() {
        return new PropIter();
    }

    public DavPropertyIterator iterator(Namespace namespace) {
        return new PropIter(namespace);
    }

    public boolean contains(DavPropertyName name) {
        return this.map.containsKey(name);
    }

    public boolean contains(String name) {
        return this.contains(DavPropertyName.create(name, DavConstants.NAMESPACE));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public DavPropertyName[] getPropertyNames() {
        Set keySet = this.map.keySet();
        return keySet.toArray(new DavPropertyName[keySet.size()]);
    }

    private class PropIter
    implements DavPropertyIterator {
        private final Namespace namespace;
        private final Iterator iterator;
        private DavProperty next;

        private PropIter() {
            this((Namespace)null);
        }

        private PropIter(Namespace namespace) {
            this.namespace = namespace;
            this.iterator = DavPropertySet.this.map.values().iterator();
            this.seek();
        }

        public DavProperty nextProperty() throws NoSuchElementException {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            DavProperty ret = this.next;
            this.seek();
            return ret;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            return this.nextProperty();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void seek() {
            while (this.iterator.hasNext()) {
                this.next = (DavProperty)this.iterator.next();
                if (this.namespace != null && !this.namespace.equals((Object)this.next.getName().getNamespace())) continue;
                return;
            }
            this.next = null;
        }
    }
}

