/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;

public class DefaultDavProperty
extends AbstractDavProperty {
    private static Logger log = Logger.getLogger(DefaultDavProperty.class);
    private final Object value;

    public DefaultDavProperty(String name, Object value, Namespace namespace, boolean isProtected) {
        super(DavPropertyName.create(name, namespace), isProtected);
        this.value = value;
    }

    public DefaultDavProperty(String name, Object value, Namespace namespace) {
        this(name, value, namespace, false);
    }

    public DefaultDavProperty(DavPropertyName name, Object value, boolean isProtected) {
        super(name, isProtected);
        this.value = value;
    }

    public DefaultDavProperty(DavPropertyName name, Object value) {
        this(name, value, false);
    }

    public Object getValue() {
        return this.value;
    }

    public static DefaultDavProperty createFromXml(Element propertyElement) {
        Object value;
        if (propertyElement == null) {
            throw new IllegalArgumentException("Cannot create a new DavProperty from a 'null' element.");
        }
        DavPropertyName name = DavPropertyName.createFromXml(propertyElement);
        int size = propertyElement.getContentSize();
        switch (size) {
            case 0: {
                value = null;
                break;
            }
            case 1: {
                Content c = propertyElement.getContent(0);
                if (c instanceof Text) {
                    value = ((Text)c).getText();
                    break;
                }
                value = c;
                break;
            }
            default: {
                value = propertyElement.getContent();
            }
        }
        return new DefaultDavProperty(name, value, false);
    }
}

