/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.util.XmlUtil;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class HrefProperty
extends AbstractDavProperty {
    private static Logger log = Logger.getLogger(HrefProperty.class);
    private final String[] value;

    public HrefProperty(DavPropertyName name, String value, boolean isProtected) {
        super(name, isProtected);
        this.value = new String[]{value};
    }

    public HrefProperty(DavPropertyName name, String[] value, boolean isProtected) {
        super(name, isProtected);
        this.value = value;
    }

    public HrefProperty(DavProperty prop) {
        super(prop.getName(), prop.isProtected());
        ArrayList<String> hrefList = new ArrayList<String>();
        Object val = prop.getValue();
        if (val instanceof List) {
            for (Object o : (List)val) {
                if (o instanceof Element) {
                    String href = ((Element)o).getChildText("href", NAMESPACE);
                    if (href != null) {
                        hrefList.add(href);
                        continue;
                    }
                    log.warn((Object)("Valid DAV:href element expected instead of " + o.toString()));
                    continue;
                }
                log.warn((Object)("DAV: href element expected in the content of " + this.getName().toString()));
            }
        } else if (val instanceof Element) {
            String href = ((Element)val).getChildText("href", NAMESPACE);
            if (href != null) {
                hrefList.add(href);
            } else {
                log.warn((Object)("Valid DAV:href element expected instead of " + val.toString()));
            }
        }
        this.value = hrefList.toArray(new String[hrefList.size()]);
    }

    public Element toXml() {
        Element elem = this.getName().toXml();
        Object value = this.getValue();
        if (value != null) {
            if (value instanceof String[]) {
                String[] hrefs = (String[])value;
                for (int i = 0; i < hrefs.length; ++i) {
                    elem.addContent((Content)XmlUtil.hrefToXml(hrefs[i]));
                }
            } else {
                elem.addContent((Content)XmlUtil.hrefToXml(value.toString()));
            }
        }
        return elem;
    }

    public Object getValue() {
        return this.value;
    }

    public List getHrefs() {
        return this.value != null ? Arrays.asList(this.value) : new ArrayList();
    }
}

