/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.search.SearchConstants;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class QueryGrammerSet
extends AbstractDavProperty
implements SearchConstants {
    private List queryLanguages = new ArrayList();

    public QueryGrammerSet() {
        this(null);
    }

    public QueryGrammerSet(String[] qLanguages) {
        super(QUERY_GRAMMER_SET, true);
        if (qLanguages != null) {
            for (int i = 0; i < qLanguages.length; ++i) {
                this.queryLanguages.add(new Element(qLanguages[i], SearchConstants.NAMESPACE));
            }
        }
    }

    public void addQueryLanguage(String qLanguage, Namespace namespace) {
        if (namespace == null) {
            namespace = SearchConstants.NAMESPACE;
        }
        this.queryLanguages.add(new Element(qLanguage, namespace));
    }

    public String[] getQueryLanguages() {
        int size = this.queryLanguages.size();
        if (size > 0) {
            String[] qLangStr = new String[size];
            Element[] elements = this.queryLanguages.toArray(new Element[size]);
            for (int i = 0; i < elements.length; ++i) {
                qLangStr[i] = elements[i].getNamespaceURI() + elements[i].getName();
            }
            return qLangStr;
        }
        return new String[0];
    }

    public Element toXml() {
        Element elem = this.getName().toXml();
        Iterator qlIter = this.queryLanguages.iterator();
        while (qlIter.hasNext()) {
            Element grammer = new Element("grammar", SearchConstants.NAMESPACE).addContent((Content)((Element)qlIter.next()));
            Element sqg = new Element("supported-query-grammar", SearchConstants.NAMESPACE).addContent((Content)grammer);
            elem.addContent((Content)sqg);
        }
        return elem;
    }

    public Object getValue() {
        return this.queryLanguages;
    }
}

