/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class LabelInfo
implements DeltaVConstants {
    private static Logger log = Logger.getLogger(LabelInfo.class);
    public static final int TYPE_SET = 0;
    public static final int TYPE_REMOVE = 1;
    public static final int TYPE_ADD = 2;
    private final Element labelElement;
    private final int depth;
    private int type;
    private String labelName;

    public LabelInfo(Element labelElement, int depth) {
        if (labelElement == null || !labelElement.getName().equals("label")) {
            throw new IllegalArgumentException("label element expected");
        }
        this.labelElement = (Element)labelElement.detach();
        for (Element child : labelElement.getChildren()) {
            if (!NAMESPACE.equals((Object)child.getNamespace())) continue;
            String name = child.getName();
            if ("add".equals(name)) {
                this.type = 2;
                this.setLabelName(child);
                continue;
            }
            if ("remove".equals(name)) {
                this.type = 1;
                this.setLabelName(child);
                continue;
            }
            if (!"set".equals(name)) continue;
            this.type = 0;
            this.setLabelName(child);
        }
        this.depth = depth;
    }

    public LabelInfo(Element labelElement) {
        this(labelElement, 0);
    }

    public String getLabelName() {
        return this.labelName;
    }

    private void setLabelName(Element parent) {
        if (this.labelName != null) {
            throw new IllegalArgumentException("The DAV:label element may contain at most one DAV:add, DAV:set, or DAV:remove element");
        }
        this.labelName = parent.getChildText("label-name", NAMESPACE);
    }

    public int getType() {
        return this.type;
    }

    public int getDepth() {
        return this.depth;
    }

    public Element getLabelElement() {
        return this.labelElement;
    }
}

