/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.DeltaVResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class ExpandPropertyReport
implements Report,
DeltaVConstants {
    private static Logger log = Logger.getLogger(ExpandPropertyReport.class);
    private DeltaVResource resource;
    private ReportInfo info;
    private List properties;

    public ReportType getType() {
        return ReportType.EXPAND_PROPERTY;
    }

    public void setResource(DeltaVResource resource) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("The resource specified must not be null.");
        }
        this.resource = resource;
    }

    public void setInfo(ReportInfo info) throws IllegalArgumentException {
        if (info == null || !"expand-property".equals(info.getReportElement().getName())) {
            throw new IllegalArgumentException("DAV:expand-property element expected.");
        }
        this.info = info;
        this.properties = info.getReportElement().getChildren("property", NAMESPACE);
    }

    public Document toXml() throws DavException {
        if (this.info == null || this.resource == null) {
            throw new DavException(500, "Error while running DAV:version-tree report");
        }
        MultiStatus ms = new MultiStatus();
        this.buildMultiStatus(this.resource, this.info.getDepth(), ms);
        return ms.toXml();
    }

    private void buildMultiStatus(DavResource res, int depth, MultiStatus ms) throws DavException {
        MultiStatusResponse response = this.getResponse(res, this.properties);
        ms.addResponse(response);
        if (depth > 0) {
            DavResourceIterator it = res.getMembers();
            while (it.hasNext()) {
                this.buildMultiStatus(it.nextResource(), depth - 1, ms);
            }
        }
    }

    private MultiStatusResponse getResponse(DavResource res, List propertyList) {
        MultiStatusResponse resp = new MultiStatusResponse(res.getHref());
        for (Element propertyElem : propertyList) {
            Namespace namespace;
            Attribute nameAttr = propertyElem.getAttribute("name");
            if (nameAttr == null) continue;
            Attribute namespaceAttr = propertyElem.getAttribute("namespace");
            String name = nameAttr.getValue();
            DavPropertyName propName = DavPropertyName.create(name, namespace = namespaceAttr != null ? Namespace.getNamespace((String)namespaceAttr.getValue()) : NAMESPACE);
            DavProperty p = res.getProperty(propName);
            if (p != null) {
                if (p instanceof HrefProperty && res instanceof DeltaVResource) {
                    resp.add(new ExpandProperty((DeltaVResource)res, (HrefProperty)p, propertyElem.getChildren("property", NAMESPACE)));
                    continue;
                }
                resp.add(p);
                continue;
            }
            resp.add(propName, 404);
        }
        return resp;
    }

    private class ExpandProperty
    extends AbstractDavProperty {
        private List valueList;

        private ExpandProperty(DeltaVResource deltaVResource, HrefProperty hrefProperty, List propertyList) {
            super(hrefProperty.getName(), hrefProperty.isProtected());
            this.valueList = new ArrayList();
            try {
                DavResource[] refResource = deltaVResource.getReferenceResources(hrefProperty.getName());
                for (int i = 0; i < refResource.length; ++i) {
                    MultiStatusResponse resp = ExpandPropertyReport.this.getResponse(refResource[i], propertyList);
                    this.valueList.add(resp.toXml());
                }
            }
            catch (DavException e) {
                log.error((Object)e.getMessage());
            }
        }

        public Object getValue() {
            return this.valueList;
        }
    }
}

