/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.HashMap;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.report.ExpandPropertyReport;
import org.apache.jackrabbit.webdav.version.report.LocateByHistoryReport;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.VersionTreeReport;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

public class ReportType
implements DeltaVConstants {
    private static Logger log = Logger.getLogger(ReportType.class);
    private static final HashMap types = new HashMap();
    public static final ReportType VERSION_TREE = ReportType.register("version-tree", NAMESPACE, VersionTreeReport.class);
    public static final ReportType EXPAND_PROPERTY = ReportType.register("expand-property", NAMESPACE, ExpandPropertyReport.class);
    public static final ReportType LOCATE_BY_HISTORY = ReportType.register("locate-by-history", NAMESPACE, LocateByHistoryReport.class);
    private final String name;
    private final Namespace namespace;
    private final Class reportClass;

    private ReportType(String name, Namespace namespace, Class reportClass) {
        this.name = name;
        this.namespace = namespace;
        this.reportClass = reportClass;
    }

    public Report createReport() throws DavException {
        try {
            return (Report)this.reportClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new DavException(500, "Failed to register Report.");
        }
    }

    public Element toXml() {
        return new Element(this.name, this.namespace);
    }

    public boolean isRequestedReportType(ReportInfo reqInfo) {
        Element elem;
        if (reqInfo != null && (elem = reqInfo.getReportElement()) != null) {
            return this.name.equals(elem.getName()) && this.namespace.equals((Object)elem.getNamespace());
        }
        return false;
    }

    public static ReportType register(String name, Namespace namespace, Class reportClass) {
        if (name == null || namespace == null || reportClass == null) {
            throw new IllegalArgumentException("A ReportType cannot be registered with a null name, namespace or report class");
        }
        String key = ReportType.buildKey(namespace, name);
        if (types.containsKey(key)) {
            return (ReportType)types.get(key);
        }
        boolean isValidClass = false;
        Class<?>[] interfaces = reportClass.getInterfaces();
        for (int i = 0; i < interfaces.length && !isValidClass; ++i) {
            isValidClass = interfaces[i] == Report.class;
        }
        if (!isValidClass) {
            throw new IllegalArgumentException("The specified report class must implement the Report interface.");
        }
        try {
            reportClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The specified report class must provide a default constructor.");
        }
        ReportType type = new ReportType(name, namespace, reportClass);
        types.put(key, type);
        return type;
    }

    public static ReportType getType(ReportInfo reportInfo) {
        if (reportInfo == null) {
            throw new IllegalArgumentException("ReportInfo must not be null.");
        }
        String key = ReportType.buildKey(reportInfo.getReportElement().getNamespace(), reportInfo.getReportElement().getName());
        if (types.containsKey(key)) {
            return (ReportType)types.get(key);
        }
        throw new IllegalArgumentException("The request report '" + key + "' has not been registered yet.");
    }

    private static String buildKey(Namespace namespace, String name) {
        return "{" + namespace.getURI() + "}" + name;
    }
}

