/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.DeltaVResource;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.VersionResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.log4j.Logger;
import org.jdom.Document;

public class VersionTreeReport
implements Report,
DeltaVConstants {
    private static Logger log = Logger.getLogger(VersionTreeReport.class);
    private ReportInfo info;
    private DeltaVResource resource;

    public ReportType getType() {
        return ReportType.VERSION_TREE;
    }

    public void setResource(DeltaVResource resource) throws IllegalArgumentException {
        if (!(resource instanceof VersionControlledResource) && !(resource instanceof VersionResource)) {
            throw new IllegalArgumentException("DAV:version-tree report can only be created for version-controlled resources and version resources.");
        }
        this.resource = resource;
    }

    public void setInfo(ReportInfo info) throws IllegalArgumentException {
        if (info == null || !"version-tree".equals(info.getReportElement().getName())) {
            throw new IllegalArgumentException("DAV:version-tree element expected.");
        }
        this.info = info;
    }

    public Document toXml() throws DavException {
        if (this.info == null || this.resource == null) {
            throw new DavException(500, "Error while running DAV:version-tree report");
        }
        MultiStatus ms = new MultiStatus();
        this.buildResponse(this.resource, this.info.getPropertyNameSet(), this.info.getDepth(), ms);
        return ms.toXml();
    }

    private void buildResponse(DavResource res, DavPropertyNameSet propNameSet, int depth, MultiStatus ms) throws DavException {
        VersionResource[] versions = VersionTreeReport.getVersions(res);
        for (int i = 0; i < versions.length; ++i) {
            if (propNameSet.isEmpty()) {
                ms.addResourceStatus(versions[i], 200, 0);
                continue;
            }
            ms.addResourceProperties(versions[i], propNameSet, 0);
        }
        if (depth > 0) {
            DavResourceIterator it = res.getMembers();
            while (it.hasNext()) {
                this.buildResponse(it.nextResource(), propNameSet, depth - 1, ms);
            }
        }
    }

    private static VersionResource[] getVersions(DavResource res) throws DavException {
        VersionResource[] versions = new VersionResource[]{};
        if (res instanceof VersionControlledResource) {
            versions = ((VersionControlledResource)res).getVersionHistory().getVersions();
        } else if (res instanceof VersionResource) {
            versions = ((VersionResource)res).getVersionHistory().getVersions();
        }
        return versions;
    }
}

