/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.ordering;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.webdav.ordering.OrderingConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Position
implements OrderingConstants,
XmlSerializable {
    private static Logger log = Logger.getLogger((Class)Position.class);
    private static final Set VALID_TYPES = new HashSet();
    private final String type;
    private final String segment;

    public Position(String type) {
        if (!VALID_TYPES.contains(type)) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        if (!"first".equals(type) && !"last".equals(type)) {
            throw new IllegalArgumentException("If type is other than 'first' or 'last' a segment must be specified");
        }
        this.type = type;
        this.segment = null;
    }

    public Position(String type, String segment) {
        if (!VALID_TYPES.contains(type)) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        if (("after".equals(type) || "before".equals(type)) && (segment == null || "".equals(segment))) {
            throw new IllegalArgumentException("If type is other than 'first' or 'last' a segment must be specified");
        }
        this.type = type;
        this.segment = segment;
    }

    public String getType() {
        return this.type;
    }

    public String getSegment() {
        return this.segment;
    }

    public Element toXml(Document document) {
        Element pos = DomUtil.createElement(document, "position", NAMESPACE);
        DomUtil.addChildElement(pos, this.type, NAMESPACE, this.segment);
        return pos;
    }

    public static Position createFromXml(Element positionElement) {
        if (!DomUtil.matches(positionElement, "position", NAMESPACE)) {
            throw new IllegalArgumentException("The 'DAV:position' element required.");
        }
        ElementIterator it = DomUtil.getChildren(positionElement);
        while (it.hasNext()) {
            Element el = it.nextElement();
            String type = el.getLocalName();
            String segmentText = DomUtil.getChildText(el, "segment", NAMESPACE);
            new Position(type, segmentText);
        }
        throw new IllegalArgumentException("The 'DAV:position' element required with exact one child indicating the type.");
    }

    static {
        VALID_TYPES.add("first");
        VALID_TYPES.add("last");
        VALID_TYPES.add("after");
        VALID_TYPES.add("before");
    }
}

