/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import java.util.ArrayList;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateInfo
implements DeltaVConstants,
XmlSerializable {
    private static Logger log = Logger.getLogger((Class)UpdateInfo.class);
    private final Element updateElement;
    private final DavPropertyNameSet propertyNameSet;
    private String[] versionHref;
    private String[] labelName;
    private String workspaceHref;

    public UpdateInfo(Element updateElement) throws DavException {
        Element el;
        if (!DomUtil.matches(updateElement, "update", NAMESPACE)) {
            log.warn((Object)"DAV:update element expected");
            throw new DavException(400);
        }
        boolean done = false;
        ElementIterator it = DomUtil.getChildren(updateElement, "version", NAMESPACE);
        while (it.hasNext()) {
            ArrayList<String> hrefList = new ArrayList<String>();
            el = it.nextElement();
            hrefList.add(DomUtil.getChildText(el, "href", DavConstants.NAMESPACE));
            this.versionHref = hrefList.toArray(new String[hrefList.size()]);
            done = true;
        }
        if (!done) {
            it = DomUtil.getChildren(updateElement, "label-name", NAMESPACE);
            while (it.hasNext()) {
                ArrayList<String> labelList = new ArrayList<String>();
                el = it.nextElement();
                labelList.add(DomUtil.getText(el));
                this.labelName = labelList.toArray(new String[labelList.size()]);
                done = true;
            }
        }
        if (!done) {
            Element wspElem = DomUtil.getChildElement(updateElement, "workspace", NAMESPACE);
            if (wspElem != null) {
                this.workspaceHref = DomUtil.getChildTextTrim(wspElem, "href", DavConstants.NAMESPACE);
            } else {
                log.warn((Object)"DAV:update element must contain either DAV:version, DAV:label-name or DAV:workspace child element.");
                throw new DavException(400);
            }
        }
        if (DomUtil.hasChildElement(updateElement, "prop", DavConstants.NAMESPACE)) {
            Element propEl = DomUtil.getChildElement(updateElement, "prop", DavConstants.NAMESPACE);
            this.propertyNameSet = new DavPropertyNameSet(propEl);
            updateElement.removeChild(propEl);
        } else {
            this.propertyNameSet = new DavPropertyNameSet();
        }
        this.updateElement = updateElement;
    }

    public String[] getVersionHref() {
        return this.versionHref;
    }

    public String[] getLabelName() {
        return this.labelName;
    }

    public String getWorkspaceHref() {
        return this.workspaceHref;
    }

    public DavPropertyNameSet getPropertyNameSet() {
        return this.propertyNameSet;
    }

    public Element getUpdateElement() {
        return this.updateElement;
    }

    public Element toXml(Document document) {
        Element elem = (Element)document.importNode(this.updateElement, true);
        if (!this.propertyNameSet.isEmpty()) {
            elem.appendChild(this.propertyNameSet.toXml(document));
        }
        return elem;
    }
}

