/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.VersionResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VersionTreeReport
implements Report,
DeltaVConstants {
    private static Logger log = Logger.getLogger((Class)VersionTreeReport.class);
    private ReportInfo info;
    private DavResource resource;

    public ReportType getType() {
        return ReportType.VERSION_TREE;
    }

    public boolean isMultiStatusReport() {
        return true;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        this.setResource(resource);
        this.setInfo(info);
    }

    private void setResource(DavResource resource) throws DavException {
        if (resource == null || !(resource instanceof VersionControlledResource) && !(resource instanceof VersionResource)) {
            throw new DavException(400, "DAV:version-tree report can only be created for version-controlled resources and version resources.");
        }
        this.resource = resource;
    }

    private void setInfo(ReportInfo info) throws DavException {
        if (!this.getType().isRequestedReportType(info)) {
            throw new DavException(400, "DAV:version-tree element expected.");
        }
        this.info = info;
    }

    public Element toXml(Document document) {
        return this.getMultiStatus().toXml(document);
    }

    private MultiStatus getMultiStatus() {
        if (this.info == null || this.resource == null) {
            throw new NullPointerException("Error while running DAV:version-tree report");
        }
        MultiStatus ms = new MultiStatus();
        this.buildResponse(this.resource, this.info.getPropertyNameSet(), this.info.getDepth(), ms);
        return ms;
    }

    private void buildResponse(DavResource res, DavPropertyNameSet propNameSet, int depth, MultiStatus ms) {
        try {
            VersionResource[] versions = VersionTreeReport.getVersions(res);
            for (int i = 0; i < versions.length; ++i) {
                if (propNameSet.isEmpty()) {
                    ms.addResourceStatus(versions[i], 200, 0);
                    continue;
                }
                ms.addResourceProperties(versions[i], propNameSet, 0);
            }
        }
        catch (DavException e) {
            log.error((Object)e);
        }
        if (depth > 0) {
            DavResourceIterator it = res.getMembers();
            while (it.hasNext()) {
                this.buildResponse(it.nextResource(), propNameSet, depth - 1, ms);
            }
        }
    }

    private static VersionResource[] getVersions(DavResource res) throws DavException {
        VersionResource[] versions = new VersionResource[]{};
        if (res instanceof VersionControlledResource) {
            versions = ((VersionControlledResource)res).getVersionHistory().getVersions();
        } else if (res instanceof VersionResource) {
            versions = ((VersionResource)res).getVersionHistory().getVersions();
        }
        return versions;
    }
}

