/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.ComponentProperty;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.DirectGeneric;
import org.jibx.binding.def.ElementWrapper;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.OptionalStructureWrapper;
import org.jibx.binding.def.PassThroughComponent;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.JiBXException;

public class MappingReference
extends PassThroughComponent {
    private final IContainer m_container;
    private final PropertyDefinition m_property;
    private String m_type;
    private final IContextObj m_contextObject;
    private final NameDefinition m_name;
    private final boolean m_isSynthetic;

    public MappingReference(IContainer contain, PropertyDefinition prop, String type, IContextObj objc, NameDefinition name, boolean synth) {
        this.m_container = contain;
        this.m_property = prop;
        this.m_type = type;
        this.m_contextObject = objc;
        this.m_name = name;
        this.m_isSynthetic = synth;
    }

    public String getType() {
        return this.m_type;
    }

    public void setLinkages() throws JiBXException {
        DefinitionContext defc = this.m_container.getDefinitionContext();
        IMapping mdef = defc.getClassMapping(this.m_type);
        IComponent wrap = null;
        PropertyDefinition prop = this.m_property;
        if (mdef == null) {
            if (this.m_name != null) {
                throw new JiBXException("Name not allowed for generic mapping of type " + this.m_type);
            }
            wrap = new DirectGeneric(this.m_container, this.m_type, prop);
        } else if (this.m_isSynthetic && mdef.isAbstract() && !mdef.isBase()) {
            wrap = new DirectGeneric(this.m_container, this.m_type, prop);
        } else {
            if (prop.isImplicit()) {
                prop.setOptional(false);
            }
            String type = mdef.getBoundType();
            if (prop.getTypeName() == null) {
                prop = new PropertyDefinition(type, this.m_contextObject, prop.isOptional());
            }
            wrap = mdef.buildRef(this.m_container, this.m_contextObject, prop.getTypeName(), prop);
            if (this.m_name != null) {
                if (mdef.getName() == null) {
                    IComponent icomp = wrap;
                    wrap = new ElementWrapper(defc, this.m_name, icomp);
                    if (prop.isImplicit()) {
                        ((ElementWrapper)wrap).setDirect(true);
                    }
                    if (prop.isOptional()) {
                        if (icomp instanceof ComponentProperty) {
                            ((ComponentProperty)icomp).setSkipping(true);
                        }
                        ((ElementWrapper)wrap).setOptionalNormal(true);
                        ((ElementWrapper)wrap).setStructureObject(true);
                        wrap = new OptionalStructureWrapper(wrap, prop, true);
                        this.m_property.setOptional(false);
                    }
                } else {
                    throw new JiBXException("Name not allowed for reference to mapping of type " + type + ", which already defines a name");
                }
            }
            this.m_type = mdef.getReferenceType();
        }
        this.setWrappedComponent(wrap);
        super.setLinkages();
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("mapping reference to " + this.m_type);
        if (this.m_property != null) {
            System.out.print(" using " + this.m_property.toString());
        }
        System.out.println();
        if (this.m_component != null) {
            this.m_component.print(depth + 1);
        }
    }
}

