/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.ValidationContext;
import org.jibx.binding.util.StringArray;
import org.jibx.runtime.ITrackSource;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public abstract class ElementBase {
    public static final int BINDING_ELEMENT = 0;
    public static final int COLLECTION_ELEMENT = 1;
    public static final int FORMAT_ELEMENT = 2;
    public static final int MAPPING_ELEMENT = 3;
    public static final int NAMESPACE_ELEMENT = 4;
    public static final int STRUCTURE_ELEMENT = 5;
    public static final int TEMPLATE_ELEMENT = 6;
    public static final int VALUE_ELEMENT = 7;
    public static final int INCLUDE_ELEMENT = 8;
    public static final int SPLIT_ELEMENT = 9;
    public static final int INPUT_ELEMENT = 10;
    public static final int OUTPUT_ELEMENT = 11;
    public static final String[] ELEMENT_NAMES = new String[]{"binding", "collection", "format", "mapping", "namespace", "structure", "template", "value", "include", "split", "input", "output"};
    private final int m_type;
    private String m_comment;

    protected ElementBase(int type) {
        this.m_type = type;
    }

    public final int type() {
        return this.m_type;
    }

    public final String name() {
        return ELEMENT_NAMES[this.m_type];
    }

    public final String getComment() {
        return this.m_comment;
    }

    public final void setComment(String text) {
        this.m_comment = text;
    }

    protected void validateAttributes(IUnmarshallingContext ictx, StringArray attrs) {
        int count = ictx.getStackDepth();
        BindingElement.UnmarshalWrapper wrapper = (BindingElement.UnmarshalWrapper)ictx.getStackObject(count - 1);
        ValidationContext vctx = wrapper.getValidation();
        UnmarshallingContext uctx = (UnmarshallingContext)ictx;
        for (int i = 0; i < uctx.getAttributeCount(); ++i) {
            String name = uctx.getAttributeName(i);
            if (uctx.getAttributeNamespace(i).length() != 0 || attrs.indexOf(name) >= 0) continue;
            vctx.addWarning("Undefined attribute " + name, this);
        }
    }

    public void prevalidate(ValidationContext vctx) {
    }

    public void validate(ValidationContext vctx) {
    }

    public String toString() {
        ITrackSource track;
        int line;
        StringBuffer buff = new StringBuffer();
        buff.append('<');
        buff.append(this.name());
        buff.append('>');
        buff.append(" element");
        if (this instanceof ITrackSource && (line = (track = (ITrackSource)this).jibx_getLineNumber()) >= 0) {
            buff.append(" (line ");
            buff.append(line);
            buff.append(", column ");
            buff.append(track.jibx_getColumnNumber());
            String dname = track.jibx_getDocumentName();
            if (dname == null) {
                buff.append(')');
            } else {
                buff.append(" in '");
                buff.append(dname);
                buff.append("')");
            }
        }
        return buff.toString();
    }
}

