/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.io.OutputStream;
import java.io.Writer;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class BindingSelector {
    private final String m_attributeUri;
    private final String m_attributeName;
    private final String[] m_versionTexts;
    private final String[] m_versionBindings;
    private final UnmarshallingContext m_context;
    private OutputStream m_outputStream;
    private String m_outputEncoding;
    private Writer m_outputWriter;
    private int m_outputIndent;

    public BindingSelector(String uri, String name, String[] versions, String[] bindings) {
        this.m_attributeUri = uri;
        this.m_attributeName = name;
        this.m_versionTexts = versions;
        this.m_versionBindings = bindings;
        this.m_context = new UnmarshallingContext();
        this.m_outputIndent = -1;
    }

    public IUnmarshallingContext getContext() {
        return this.m_context;
    }

    public void setOutput(OutputStream outs, String enc) {
        this.m_outputStream = outs;
        this.m_outputEncoding = enc;
    }

    public void setOutput(Writer outw) {
        this.m_outputWriter = outw;
    }

    public void setIndent(int indent) {
        this.m_outputIndent = indent;
    }

    public void marshalVersioned(Object obj, String version) throws JiBXException {
        String match = version == null ? this.m_versionTexts[0] : version;
        for (int i = 0; i < this.m_versionTexts.length; ++i) {
            if (!match.equals(this.m_versionTexts[i])) continue;
            IBindingFactory fact = BindingDirectory.getFactory((String)this.m_versionBindings[i], obj.getClass());
            MarshallingContext context = (MarshallingContext)fact.createMarshallingContext();
            context.setIndent(this.m_outputIndent);
            if (this.m_outputWriter == null) {
                if (this.m_outputStream == null) {
                    throw new JiBXException("Output not configured");
                }
                context.setOutput(this.m_outputStream, this.m_outputEncoding);
            } else {
                context.setOutput(this.m_outputWriter);
            }
            context.startDocument(this.m_outputEncoding, null);
            ((IMarshallable)obj).marshal((IMarshallingContext)context);
            context.endDocument();
            return;
        }
        throw new JiBXException("Unrecognized document version " + version);
    }

    public Object unmarshalVersioned(Class clas) throws JiBXException {
        this.m_context.toStart();
        String version = this.m_context.attributeText(this.m_attributeUri, this.m_attributeName, this.m_versionTexts[0]);
        for (int i = 0; i < this.m_versionTexts.length; ++i) {
            if (!version.equals(this.m_versionTexts[i])) continue;
            IBindingFactory fact = BindingDirectory.getFactory((String)this.m_versionBindings[i], (Class)clas);
            UnmarshallingContext context = (UnmarshallingContext)fact.createUnmarshallingContext();
            context.setFromContext(this.m_context);
            return context.unmarshalElement();
        }
        throw new JiBXException("Unrecognized document version " + version);
    }
}

