/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.jmeter.protocol.java.sampler.BSFSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class BSFSamplerGui
extends AbstractSamplerGui {
    private JTextArea scriptField;
    private JTextField langField;
    private JTextField filename;
    private JTextField parameters;

    public BSFSamplerGui() {
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.scriptField.setText(element.getPropertyAsString("BSFSampler.query"));
        this.langField.setText(element.getPropertyAsString("BSFSampler.language"));
        this.filename.setText(element.getPropertyAsString("BSFSampler.filename"));
        this.parameters.setText(element.getPropertyAsString("BSFSampler.parameters"));
    }

    public TestElement createTestElement() {
        BSFSampler sampler = new BSFSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement te) {
        te.clear();
        this.configureTestElement(te);
        te.setProperty("BSFSampler.filename", this.filename.getText());
        te.setProperty("BSFSampler.language", this.langField.getText());
        te.setProperty("BSFSampler.parameters", this.parameters.getText());
        te.setProperty("BSFSampler.query", this.scriptField.getText());
    }

    public String getLabelResource() {
        return "bsf_sampler_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createLanguagePanel());
        box.add(this.createFilenamePanel());
        box.add(this.createParameterPanel());
        this.add(box, "North");
        JPanel panel = this.createScriptPanel();
        this.add(panel, "Center");
        this.add(Box.createVerticalStrut(panel.getPreferredSize().height), "West");
    }

    private JPanel createParameterPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"bsf_script_parameters"));
        this.parameters = new JTextField(10);
        this.parameters.setName("BSFSampler.parameters");
        label.setLabelFor(this.parameters);
        JPanel parameterPanel = new JPanel(new BorderLayout(5, 0));
        parameterPanel.add((Component)label, "West");
        parameterPanel.add((Component)this.parameters, "Center");
        return parameterPanel;
    }

    private JPanel createFilenamePanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"bsf_script_file"));
        this.filename = new JTextField(10);
        this.filename.setName("BSFSampler.filename");
        label.setLabelFor(this.filename);
        JPanel filenamePanel = new JPanel(new BorderLayout(5, 0));
        filenamePanel.add((Component)label, "West");
        filenamePanel.add((Component)this.filename, "Center");
        return filenamePanel;
    }

    private JPanel createLanguagePanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"bsf_script_language"));
        this.langField = new JTextField(10);
        this.langField.setName("BSFSampler.language");
        label.setLabelFor(this.langField);
        JPanel langPanel = new JPanel(new BorderLayout(5, 0));
        langPanel.add((Component)label, "West");
        langPanel.add((Component)this.langField, "Center");
        return langPanel;
    }

    private JPanel createScriptPanel() {
        this.scriptField = new JTextArea();
        this.scriptField.setRows(4);
        this.scriptField.setLineWrap(true);
        this.scriptField.setWrapStyleWord(true);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"bsf_script"));
        label.setLabelFor(this.scriptField);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)new JScrollPane(this.scriptField), "Center");
        return panel;
    }
}

