/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.jorphan.collections.HashTree;

public class ListedHashTree
extends HashTree
implements Serializable,
Cloneable {
    private List order;

    public ListedHashTree() {
        this.data = new HashMap();
        this.order = new LinkedList();
    }

    public Object clone() {
        ListedHashTree newTree = new ListedHashTree();
        this.cloneTree(newTree);
        return newTree;
    }

    public ListedHashTree(Object key) {
        this.data = new HashMap();
        this.order = new LinkedList();
        this.data.put(key, new ListedHashTree());
        this.order.add(key);
    }

    public ListedHashTree(Collection keys) {
        this.data = new HashMap();
        this.order = new LinkedList();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object temp = it.next();
            this.data.put(temp, new ListedHashTree());
            this.order.add(temp);
        }
    }

    public ListedHashTree(Object[] keys) {
        this.data = new HashMap();
        this.order = new LinkedList();
        for (int x = 0; x < keys.length; ++x) {
            this.data.put(keys[x], new ListedHashTree());
            this.order.add(keys[x]);
        }
    }

    public void set(Object key, Object value) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, value);
    }

    public void set(Object key, HashTree t) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, t);
    }

    public void set(Object key, Object[] values) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, values);
    }

    public void set(Object key, Collection values) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, values);
    }

    public void replace(Object currentKey, Object newKey) {
        HashTree tree = this.getTree(currentKey);
        this.data.remove(currentKey);
        this.data.put(newKey, tree);
        this.order.set(this.order.indexOf(currentKey), newKey);
    }

    public HashTree createNewTree() {
        return new ListedHashTree();
    }

    public HashTree createNewTree(Object key) {
        return new ListedHashTree(key);
    }

    public HashTree createNewTree(Collection values) {
        return new ListedHashTree(values);
    }

    public HashTree add(Object key) {
        if (!this.data.containsKey(key)) {
            HashTree newTree = this.createNewTree();
            this.data.put(key, newTree);
            this.order.add(key);
            return newTree;
        }
        return this.getTree(key);
    }

    public Collection list() {
        return this.order;
    }

    public Object remove(Object key) {
        this.order.remove(key);
        return this.data.remove(key);
    }

    public Object[] getArray() {
        return this.order.toArray();
    }

    public int hashCode() {
        int hc = 17;
        hc = hc * 37 + (this.order == null ? 0 : ((Object)this.order).hashCode());
        hc = hc * 37 + super.hashCode();
        return hc;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ListedHashTree)) {
            return false;
        }
        ListedHashTree lht = (ListedHashTree)o;
        return super.equals(lht) && ((Object)this.order).equals(lht.order);
    }

    public Set keySet() {
        return this.data.keySet();
    }

    public int size() {
        return this.data.size();
    }

    void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    public void clear() {
        super.clear();
        this.order.clear();
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testAddObjectAndTree() throws Exception {
            ListedHashTree tree = new ListedHashTree("key");
            ListedHashTree newTree = new ListedHashTree("value");
            tree.add((Object)"key", newTree);
            Test.assertEquals((int)tree.list().size(), (int)1);
            Test.assertEquals((Object)"key", (Object)tree.getArray()[0]);
            Test.assertEquals((int)1, (int)tree.getTree("key").list().size());
            Test.assertEquals((int)0, (int)tree.getTree("key").getTree("value").size());
            Test.assertEquals((Object)tree.getTree("key").getArray()[0], (Object)"value");
            Test.assertNotNull((Object)tree.getTree("key").get("value"));
        }

        public void testEqualsAndHashCode() throws Exception {
            ListedHashTree tree1 = new ListedHashTree("abcd");
            ListedHashTree tree2 = new ListedHashTree("abcd");
            ListedHashTree tree3 = new ListedHashTree("abcde");
            ListedHashTree tree4 = new ListedHashTree("abcde");
            Test.assertTrue((boolean)tree1.equals(tree1));
            Test.assertTrue((boolean)tree1.equals(tree2));
            Test.assertTrue((boolean)tree2.equals(tree1));
            Test.assertTrue((boolean)tree2.equals(tree2));
            Test.assertTrue((tree1.hashCode() == tree2.hashCode() ? 1 : 0) != 0);
            Test.assertTrue((boolean)tree3.equals(tree3));
            Test.assertTrue((boolean)tree3.equals(tree4));
            Test.assertTrue((boolean)tree4.equals(tree3));
            Test.assertTrue((boolean)tree4.equals(tree4));
            Test.assertTrue((tree3.hashCode() == tree4.hashCode() ? 1 : 0) != 0);
            Test.assertNotSame((Object)tree1, (Object)tree2);
            Test.assertNotSame((Object)tree1, (Object)tree3);
            Test.assertFalse((boolean)tree1.equals(tree3));
            Test.assertFalse((boolean)tree3.equals(tree1));
            Test.assertFalse((boolean)tree1.equals(tree4));
            Test.assertFalse((boolean)tree4.equals(tree1));
            Test.assertFalse((boolean)tree2.equals(tree3));
            Test.assertFalse((boolean)tree3.equals(tree2));
            Test.assertFalse((boolean)tree2.equals(tree4));
            Test.assertFalse((boolean)tree4.equals(tree2));
            tree1.add((Object)"abcd", tree3);
            Test.assertFalse((boolean)tree1.equals(tree2));
            Test.assertFalse((boolean)tree2.equals(tree1));
            tree2.add((Object)"abcd", tree4);
            Test.assertTrue((boolean)tree1.equals(tree2));
            Test.assertTrue((boolean)tree2.equals(tree1));
            Test.assertTrue((tree1.hashCode() == tree2.hashCode() ? 1 : 0) != 0);
            tree1.add("a1");
            tree1.add("a2");
            tree2.add("a2");
            tree2.add("a1");
            Test.assertFalse((boolean)tree1.equals(tree2));
            Test.assertFalse((boolean)tree2.equals(tree1));
            if (tree1.hashCode() == tree2.hashCode()) {
                System.out.println("WARN: unequal ListedHashTrees should not have equal hashcodes");
            }
            tree4.add("abcdef");
            Test.assertFalse((boolean)tree3.equals(tree4));
            Test.assertFalse((boolean)tree4.equals(tree3));
        }
    }
}

