/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jorphan.gui.JLabeledField;

public class JLabeledRadio
extends JPanel
implements JLabeledField,
ActionListener {
    private JLabel mLabel = new JLabel();
    private ButtonGroup bGroup = new ButtonGroup();
    private ArrayList mChangeListeners = new ArrayList(3);

    public JLabeledRadio() {
        this.add(this.mLabel);
    }

    public JLabeledRadio(String label, String[] items) {
        this.mLabel.setText(label);
        this.init(items, null);
    }

    public JLabeledRadio(String label, String[] items, String selectedItem) {
        this.mLabel.setText(label);
        this.init(items, selectedItem);
    }

    public void init(String[] items, String selected) {
        this.add(this.mLabel);
        for (int idx = 0; idx < items.length; ++idx) {
            JRadioButton btn = new JRadioButton(items[idx]);
            btn.setActionCommand(items[idx]);
            btn.addActionListener(this);
            this.bGroup.add(btn);
            this.add(btn);
            if (selected == null || !selected.equals(items[idx])) continue;
            btn.setSelected(true);
        }
    }

    public void setItems(String[] items) {
        Enumeration<AbstractButton> en = this.bGroup.getElements();
        while (en.hasMoreElements()) {
            JComponent comp = en.nextElement();
            this.bGroup.remove((JRadioButton)comp);
            this.remove(comp);
        }
        this.init(items, null);
    }

    public String getText() {
        return this.bGroup.getSelection().getActionCommand();
    }

    public void setText(String text) {
        Enumeration<AbstractButton> en = this.bGroup.getElements();
        while (en.hasMoreElements()) {
            JRadioButton jrb = (JRadioButton)en.nextElement();
            if (jrb.getText().equals(text)) {
                this.bGroup.setSelected(jrb.getModel(), true);
                continue;
            }
            this.bGroup.setSelected(jrb.getModel(), false);
        }
    }

    public void setLabel(String pLabel) {
        this.mLabel.setText(pLabel);
    }

    public void addChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.add(pChangeListener);
    }

    private void notifyChangeListeners() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int index = 0; index < this.mChangeListeners.size(); ++index) {
            ((ChangeListener)this.mChangeListeners.get(index)).stateChanged(ce);
        }
    }

    public List getComponentList() {
        LinkedList<JComponent> comps = new LinkedList<JComponent>();
        comps.add(this.mLabel);
        Enumeration<AbstractButton> en = this.bGroup.getElements();
        while (en.hasMoreElements()) {
            comps.add(en.nextElement());
        }
        return comps;
    }

    public void actionPerformed(ActionEvent e) {
        this.notifyChangeListeners();
    }
}

