/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.logging;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Properties;
import org.apache.avalon.excalibur.logger.LogKitLoggerManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.jorphan.util.ClassContext;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.NullOutputLogTarget;
import org.apache.log.output.io.WriterTarget;
import org.xml.sax.SAXException;

public final class LoggingManager {
    private static final String DEFAULT_PATTERN = "%{time:yyyy/MM/dd HH:mm:ss} %5.5{priority} - %{category}: %{message} %{throwable}";
    private static final String PATTERN_THREAD_PREFIX = "%{time:yyyy/MM/dd HH:mm:ss} %5.5{priority} %12{thread} %{category}: %{message} %{throwable}";
    private static final String PATTERN_THREAD_SUFFIX = "%{time:yyyy/MM/dd HH:mm:ss} %5.5{priority} %{category}[%{thread}]: %{message} %{throwable}";
    private static PatternFormatter format = null;
    private static LogTarget target;
    private static boolean isTargetSystemOut;
    private static boolean isWriterSystemOut;
    public static final String LOG_FILE = "log_file";
    public static final String LOG_PRIORITY = "log_level";
    private static LoggingManager logManager;
    private static final String PACKAGE_PREFIX = "org.apache.";

    private LoggingManager() {
        target = new NullOutputLogTarget();
    }

    public static LoggingManager getLogManager() {
        return logManager;
    }

    public static void initializeLogging(Properties properties) {
        if (logManager == null) {
            logManager = new LoggingManager();
        }
        LoggingManager.setFormat(properties);
        LoggingManager.setTarget(LoggingManager.makeWriter(properties.getProperty(LOG_FILE, "jmeter.log"), LOG_FILE));
        LoggingManager.setPriority(properties.getProperty(LOG_PRIORITY, "INFO"));
        LoggingManager.setLoggingLevels(properties);
        LoggingManager.setConfig(properties);
    }

    private static void setFormat(Properties properties) {
        String pattern = DEFAULT_PATTERN;
        String type = properties.getProperty("log_format_type", "");
        pattern = type.length() == 0 ? properties.getProperty("log_format", DEFAULT_PATTERN) : (type.equalsIgnoreCase("thread_suffix") ? PATTERN_THREAD_SUFFIX : (type.equalsIgnoreCase("thread_prefix") ? PATTERN_THREAD_PREFIX : DEFAULT_PATTERN));
        format = new PatternFormatter(pattern + "\n");
    }

    private static void setConfig(Properties p) {
        String cfg = p.getProperty("log_config");
        if (cfg == null) {
            return;
        }
        Hierarchy hier = Hierarchy.getDefaultHierarchy();
        LogKitLoggerManager manager = new LogKitLoggerManager(null, hier, null, null);
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        try {
            Configuration c = builder.buildFromFile(cfg);
            DefaultContext ctx = new DefaultContext();
            manager.contextualize((Context)ctx);
            manager.configure(c);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Error processing logging config " + cfg);
            System.out.println(e.toString());
        }
        catch (NullPointerException e) {
            System.out.println("Error processing logging config " + cfg);
            System.out.println("Perhaps a log target is missing?");
        }
        catch (ConfigurationException e) {
            System.out.println("Error processing logging config " + cfg);
            System.out.println(e.toString());
        }
        catch (SAXException e) {
            System.out.println("Error processing logging config " + cfg);
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println("Error processing logging config " + cfg);
            System.out.println(e.toString());
        }
        catch (ContextException e) {
            System.out.println("Error processing logging config " + cfg);
            System.out.println(e.toString());
        }
    }

    private static PatternFormatter getFormat() {
        if (format == null) {
            format = new PatternFormatter("%{time:yyyy/MM/dd HH:mm:ss} %5.5{priority} - %{category}: %{message} %{throwable}\n");
        }
        return format;
    }

    private static Writer makeWriter(String logFile, String propName) {
        Writer wt;
        isWriterSystemOut = false;
        try {
            wt = new FileWriter(logFile);
        }
        catch (Exception e) {
            System.out.println(propName + "=" + logFile + " " + e.toString());
            System.out.println("[" + propName + "-> System.out]");
            isWriterSystemOut = true;
            wt = new PrintWriter(System.out);
        }
        return wt;
    }

    private static void setLoggingLevels(Properties appProperties) {
        Iterator<Object> props = appProperties.keySet().iterator();
        while (props.hasNext()) {
            String category;
            String prop = (String)props.next();
            if (prop.startsWith("log_level.")) {
                category = prop.substring(LOG_PRIORITY.length() + 1);
                LoggingManager.setPriority(appProperties.getProperty(prop), category);
            }
            if (!prop.startsWith("log_file.")) continue;
            category = prop.substring(LOG_FILE.length() + 1);
            String file = appProperties.getProperty(prop);
            LoggingManager.setTarget((LogTarget)new WriterTarget(LoggingManager.makeWriter(file, prop), (Formatter)LoggingManager.getFormat()), category);
        }
    }

    private static String getCallerClassName() {
        String name = ClassContext.getCallerClassNameAt(3);
        if (name.startsWith(PACKAGE_PREFIX)) {
            name = name.substring(PACKAGE_PREFIX.length());
        }
        return name;
    }

    public static Logger getLoggerForClass() {
        String className = LoggingManager.getCallerClassName();
        return Hierarchy.getDefaultHierarchy().getLoggerFor(className);
    }

    public static Logger getLoggerFor(String category) {
        return Hierarchy.getDefaultHierarchy().getLoggerFor(category);
    }

    public static void setPriority(String p, String category) {
        LoggingManager.setPriority(Priority.getPriorityForName((String)p), category);
    }

    public static void setPriority(Priority p, String category) {
        Hierarchy.getDefaultHierarchy().getLoggerFor(category).setPriority(p);
    }

    public static void setPriority(String p) {
        LoggingManager.setPriority(Priority.getPriorityForName((String)p));
    }

    public static void setPriority(Priority p) {
        Hierarchy.getDefaultHierarchy().setDefaultPriority(p);
    }

    public static void setTarget(LogTarget target, String category) {
        Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(category);
        logger.setLogTargets(new LogTarget[]{target});
    }

    public static void setTarget(Writer targetFile) {
        if (target == null) {
            target = LoggingManager.getTarget(targetFile, LoggingManager.getFormat());
            isTargetSystemOut = isWriterSystemOut;
        } else {
            if (!isTargetSystemOut && target instanceof WriterTarget) {
                ((WriterTarget)target).close();
            }
            target = LoggingManager.getTarget(targetFile, LoggingManager.getFormat());
            isTargetSystemOut = isWriterSystemOut;
        }
        Hierarchy.getDefaultHierarchy().setDefaultLogTarget(target);
    }

    private static LogTarget getTarget(Writer targetFile, PatternFormatter fmt) {
        return new WriterTarget(targetFile, (Formatter)fmt);
    }

    static {
        isTargetSystemOut = false;
        isWriterSystemOut = false;
        logManager = null;
    }
}

