/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.jorphan.test.UnitTestManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public final class AllTests {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    static /* synthetic */ Class class$junit$framework$TestCase;

    private AllTests() {
    }

    private static void logprop(String prop, boolean show) {
        String value = System.getProperty(prop);
        log.info(prop + "=" + value);
        if (show) {
            System.out.println(prop + "=" + value);
        }
    }

    private static void logprop(String prop) {
        AllTests.logprop(prop, false);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("You must specify a comma-delimited list of paths to search for unit tests");
            System.exit(0);
        }
        AllTests.initializeLogging(args);
        AllTests.initializeManager(args);
        AllTests.logprop("java.version", true);
        AllTests.logprop("java.vendor");
        AllTests.logprop("java.home", true);
        AllTests.logprop("user.home");
        AllTests.logprop("user.dir", true);
        AllTests.logprop("os.name");
        AllTests.logprop("os.version");
        AllTests.logprop("os.arch");
        AllTests.logprop("java.class.version");
        String cp = System.getProperty("java.class.path");
        String[] cpe = JOrphanUtils.split(cp, File.pathSeparator);
        StringBuffer sb = new StringBuffer(3000);
        sb.append("java.class.path=");
        for (int i = 0; i < cpe.length; ++i) {
            sb.append("\n");
            sb.append(cpe[i]);
            if (new File(cpe[i]).exists()) {
                sb.append(" - OK");
                continue;
            }
            sb.append(" - ??");
        }
        log.info(sb.toString());
        System.out.println("+++++++++++");
        AllTests.logprop("java.awt.headless", true);
        AllTests.logprop("java.awt.graphicsenv", true);
        System.out.println("------------");
        System.out.println("Creating test suite");
        TestSuite suite = AllTests.suite(args[0]);
        System.out.println("Starting test run");
        TestRunner.run((Test)suite);
        System.out.println("+++++++++++");
        System.out.println("------------");
        System.exit(0);
    }

    protected static void initializeLogging(String[] args) {
        if (args.length >= 2) {
            Properties props = new Properties();
            try {
                System.out.println("Setting up logging props using file: " + args[1]);
                props.load(new FileInputStream(args[1]));
                LoggingManager.initializeLogging(props);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static void initializeManager(String[] args) {
        if (args.length >= 3) {
            try {
                System.out.println("Using initializeProperties() from " + args[2]);
                UnitTestManager um = (UnitTestManager)Class.forName(args[2]).newInstance();
                System.out.println("Setting up initial properties using: " + args[1]);
                um.initializeProperties(args[1]);
            }
            catch (Exception e) {
                System.out.println("Couldn't create: " + args[2]);
                e.printStackTrace();
            }
        }
    }

    public static TestSuite suite() {
        String[] args = new String[]{"../lib/ext", "./jmetertest.properties", "org.apache.jmeter.util.JMeterUtils"};
        AllTests.initializeManager(args);
        return AllTests.suite(args[0]);
    }

    private static TestSuite suite(String searchPaths) {
        TestSuite suite = new TestSuite();
        try {
            Iterator classes = ClassFinder.findClassesThatExtend(JOrphanUtils.split(searchPaths, ","), new Class[]{class$junit$framework$TestCase == null ? (class$junit$framework$TestCase = AllTests.class$("junit.framework.TestCase")) : class$junit$framework$TestCase}, true).iterator();
            while (classes.hasNext()) {
                String name = (String)classes.next();
                try {
                    Class<?> clazz = Class.forName(name);
                    TestSuite t = null;
                    try {
                        Method m = clazz.getMethod("suite", new Class[0]);
                        t = (TestSuite)m.invoke(clazz, null);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                    if (t == null) {
                        t = new TestSuite(clazz);
                    }
                    suite.addTest(t);
                }
                catch (Exception ex) {
                    System.out.println("Error adding test for class " + name + " " + ex.toString());
                    log.error("error adding test :", (Throwable)ex);
                }
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("", (Throwable)e);
        }
        return suite;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

