/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ViewHandlerResponseWrapper;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.jstl.core.Config;

public class ViewHandlerImpl
extends ViewHandler {
    private static Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.application");
    private static final String AFTER_VIEW_CONTENT = "com.sun.faces.AFTER_VIEW_CONTENT";
    private static final String INVOCATION_PATH = "com.sun.faces.INVOCATION_PATH";
    private String contextDefaultSuffix;
    private boolean nonDeprecatedMethodExists = false;
    private boolean checkedForNonDeprecated = false;

    public ViewHandlerImpl() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created ViewHandler instance ");
        }
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        if (!viewToRender.isRendered()) {
            return;
        }
        try {
            this.executePageToBuildView(context, viewToRender);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Completed building view for : \n" + viewToRender.getViewId());
        }
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(context, viewToRender.getRenderKitId());
        ExternalContext extContext = context.getExternalContext();
        ServletRequest request = (ServletRequest)extContext.getRequest();
        ServletResponse response = (ServletResponse)extContext.getResponse();
        ResponseWriter oldWriter = context.getResponseWriter();
        FastStringWriter strWriter = new FastStringWriter(2048);
        ResponseWriter newWriter = null;
        newWriter = null != oldWriter ? oldWriter.cloneWithWriter((Writer)strWriter) : renderKit.createResponseWriter((Writer)strWriter, null, request.getCharacterEncoding());
        context.setResponseWriter(newWriter);
        newWriter.startDocument();
        this.doRenderView(context, viewToRender);
        newWriter.endDocument();
        ResponseWriter responseWriter = null;
        responseWriter = null != oldWriter ? oldWriter.cloneWithWriter((Writer)response.getWriter()) : newWriter.cloneWithWriter((Writer)response.getWriter());
        context.setResponseWriter(responseWriter);
        String bodyContent = ((Object)strWriter).toString();
        this.replaceMarkers(bodyContent, context);
        if (null != oldWriter) {
            context.setResponseWriter(oldWriter);
        }
        Object content = extContext.getRequestMap().get(AFTER_VIEW_CONTENT);
        assert (null != content);
        if (content instanceof byte[]) {
            response.getWriter().write(new String((byte[])content));
        } else if (content instanceof char[]) {
            response.getWriter().write((char[])content);
        } else assert (false);
        response.flushBuffer();
        extContext.getRequestMap().remove(AFTER_VIEW_CONTENT);
    }

    private void doRenderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        ExternalContext extContext = context.getExternalContext();
        ApplicationAssociate associate = ApplicationAssociate.getInstance(extContext);
        if (null != associate) {
            associate.responseRendered();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "About to render view " + viewToRender.getViewId());
        }
        viewToRender.encodeAll(context);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + " context " + context;
            throw new NullPointerException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        String mapping = this.getFacesMapping(context);
        UIViewRoot viewRoot = null;
        if (mapping != null && !ViewHandlerImpl.isPrefixMapped(mapping)) {
            viewId = this.convertViewId(context, viewId);
        }
        if (extContext.getRequestPathInfo() == null && mapping != null && ViewHandlerImpl.isPrefixMapped(mapping)) {
            try {
                context.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Response Complete for" + viewId);
                }
                extContext.redirect(extContext.getRequestContextPath());
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
        } else {
            ViewHandler outerViewHandler = context.getApplication().getViewHandler();
            String renderKitId = outerViewHandler.calculateRenderKitId(context);
            viewRoot = Util.getStateManager(context).restoreView(context, viewId, renderKitId);
        }
        return viewRoot;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + "context " + context;
            throw new NullPointerException(message);
        }
        Locale locale = null;
        String renderKitId = null;
        if (context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            renderKitId = context.getViewRoot().getRenderKitId();
        }
        UIViewRoot result = (UIViewRoot)context.getApplication().createComponent("javax.faces.ViewRoot");
        result.setViewId(viewId);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created new view for " + viewId);
        }
        if (locale == null) {
            locale = context.getApplication().getViewHandler().calculateLocale(context);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Locale for this view as determined by calculateLocale " + locale.toString());
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using locale from previous view " + locale.toString());
        }
        if (renderKitId == null) {
            renderKitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("RenderKitId for this view as determined by calculateRenderKitId " + renderKitId);
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using renderKitId from previous view " + renderKitId);
        }
        result.setLocale(locale);
        result.setRenderKitId(renderKitId);
        return result;
    }

    private void executePageToBuildView(FacesContext context, UIViewRoot viewToExecute) throws IOException, FacesException {
        String requestURI;
        if (null == context || null == viewToExecute) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + " context " + context + " viewToExecute " + viewToExecute;
            throw new NullPointerException(message);
        }
        String mapping = this.getFacesMapping(context);
        if (mapping.equals(requestURI = this.updateRequestURI(viewToExecute.getViewId(), mapping))) {
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            response.sendError(404);
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("About to execute view " + requestURI);
        }
        String newViewId = requestURI;
        if (mapping != null && !ViewHandlerImpl.isPrefixMapped(mapping)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found URL pattern mapping to FacesServlet " + mapping);
            }
            newViewId = this.convertViewId(context, requestURI);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Found no URL patterns mapping to FacesServlet ");
        }
        viewToExecute.setViewId(newViewId);
        ExternalContext extContext = context.getExternalContext();
        if (extContext.getRequest() instanceof ServletRequest) {
            Config.set((ServletRequest)((ServletRequest)extContext.getRequest()), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)context.getViewRoot().getLocale());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Before dispacthMessage to newViewId " + newViewId);
        }
        Object originalResponse = extContext.getResponse();
        ViewHandlerResponseWrapper wrapped = null;
        wrapped = new ViewHandlerResponseWrapper((HttpServletResponse)extContext.getResponse());
        extContext.setResponse((Object)wrapped);
        extContext.dispatch(newViewId);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("After dispacthMessage to newViewId " + newViewId);
        }
        if (wrapped.isBytes()) {
            extContext.getRequestMap().put(AFTER_VIEW_CONTENT, wrapped.getBytes());
        } else if (wrapped.isChars()) {
            extContext.getRequestMap().put(AFTER_VIEW_CONTENT, wrapped.getChars());
        }
        extContext.setResponse(originalResponse);
    }

    public Locale calculateLocale(FacesContext context) {
        Locale perf;
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + "context " + context;
            throw new NullPointerException(message);
        }
        Locale result = null;
        Iterator locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext() && (result = this.findMatch(context, perf = (Locale)locales.next())) == null) {
        }
        if (result == null) {
            result = context.getApplication().getDefaultLocale() == null ? Locale.getDefault() : context.getApplication().getDefaultLocale();
        }
        return result;
    }

    public String calculateRenderKitId(FacesContext context) {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + "context " + context;
            throw new NullPointerException(message);
        }
        String result = null;
        Map requestParamMap = context.getExternalContext().getRequestParameterMap();
        result = (String)requestParamMap.get("javax.faces.RenderKitId");
        if (result == null && null == (result = context.getApplication().getDefaultRenderKitId())) {
            result = "HTML_BASIC";
        }
        return result;
    }

    protected Locale findMatch(FacesContext context, Locale perf) {
        Locale defaultLocale;
        Locale result = null;
        Iterator it = context.getApplication().getSupportedLocales();
        while (it.hasNext()) {
            Locale supportedLocale = (Locale)it.next();
            if (perf.equals(supportedLocale)) {
                result = supportedLocale;
                break;
            }
            if (!perf.getLanguage().equals(supportedLocale.getLanguage()) || !supportedLocale.getCountry().equals("")) continue;
            result = supportedLocale;
        }
        if (null == result && (defaultLocale = context.getApplication().getDefaultLocale()) != null) {
            if (perf.equals(defaultLocale)) {
                result = defaultLocale;
            } else if (perf.getLanguage().equals(defaultLocale.getLanguage()) && defaultLocale.getCountry().equals("")) {
                result = defaultLocale;
            }
        }
        return result;
    }

    public void writeState(FacesContext context) throws IOException {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + "context " + context;
            throw new NullPointerException(message);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Begin writing market for viewId " + context.getViewRoot().getViewId());
        }
        context.getResponseWriter().writeText((Object)"com.sun.faces.saveStateFieldMarker", null);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("End writing marker for viewId " + context.getViewRoot().getViewId());
        }
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (context == null || viewId == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + "context " + context + " viewId " + viewId;
            throw new NullPointerException(message);
        }
        if (viewId.charAt(0) != '/') {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_VIEW_ID", viewId);
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.illegal_view_id_error", viewId);
            }
            throw new IllegalArgumentException(message);
        }
        String contextPath = context.getExternalContext().getRequestContextPath();
        String mapping = this.getFacesMapping(context);
        if (mapping == null) {
            return contextPath + viewId;
        }
        if (ViewHandlerImpl.isPrefixMapped(mapping)) {
            if (mapping.equals("/*")) {
                return contextPath + viewId;
            }
            return contextPath + mapping + viewId;
        }
        int period = viewId.lastIndexOf(".");
        if (period < 0) {
            return contextPath + viewId + mapping;
        }
        if (!viewId.endsWith(mapping)) {
            return contextPath + viewId.substring(0, period) + mapping;
        }
        return contextPath + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        if (path.startsWith("/")) {
            return context.getExternalContext().getRequestContextPath() + path;
        }
        return path;
    }

    private String getFacesMapping(FacesContext context) {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]);
            message = message + " context " + context;
            throw new NullPointerException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        String mapping = (String)extContext.getRequestMap().get(INVOCATION_PATH);
        if (mapping == null) {
            Object request = extContext.getRequest();
            String servletPath = null;
            String pathInfo = null;
            if (request instanceof HttpServletRequest) {
                servletPath = extContext.getRequestServletPath();
                pathInfo = extContext.getRequestPathInfo();
            }
            if ((mapping = this.getMappingForRequest(servletPath, pathInfo)) == null && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "jsf.faces_servlet_mapping_cannot_be_determined_error", new Object[]{servletPath});
            }
        }
        if (mapping != null) {
            extContext.getRequestMap().put(INVOCATION_PATH, mapping);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "URL pattern of the FacesServlet executing the current request " + mapping);
        }
        return mapping;
    }

    private String getMappingForRequest(String servletPath, String pathInfo) {
        if (servletPath == null) {
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "servletPath " + servletPath);
            logger.log(Level.FINE, "pathInfo " + pathInfo);
        }
        if (servletPath.length() == 0) {
            return "/*";
        }
        if (pathInfo != null) {
            return servletPath;
        }
        if (servletPath.indexOf(46) < 0) {
            return servletPath;
        }
        return servletPath.substring(servletPath.lastIndexOf(46));
    }

    private String updateRequestURI(String uri, String mapping) {
        if (!ViewHandlerImpl.isPrefixMapped(mapping)) {
            return uri;
        }
        int length = mapping.length() + 1;
        StringBuilder builder = new StringBuilder(length);
        builder.append(mapping).append('/');
        String mappingMod = builder.toString();
        boolean logged = false;
        while (uri.startsWith(mappingMod)) {
            if (!logged && logger.isLoggable(Level.WARNING)) {
                logged = true;
                logger.log(Level.WARNING, "jsf.viewhandler.requestpath.recursion", new Object[]{uri, mapping});
            }
            uri = uri.substring(length - 1);
        }
        return uri;
    }

    private static boolean isPrefixMapped(String mapping) {
        return mapping.charAt(0) == '/';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertViewId(FacesContext context, String viewId) {
        ViewHandlerImpl viewHandlerImpl = this;
        synchronized (viewHandlerImpl) {
            if (this.contextDefaultSuffix == null) {
                this.contextDefaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
                if (this.contextDefaultSuffix == null) {
                    this.contextDefaultSuffix = ".jsp";
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("contextDefaultSuffix " + this.contextDefaultSuffix);
                }
            }
        }
        String convertedViewId = viewId;
        if (!convertedViewId.endsWith(this.contextDefaultSuffix)) {
            StringBuffer buffer = new StringBuffer(convertedViewId);
            int extIdx = convertedViewId.lastIndexOf(46);
            if (extIdx != -1) {
                buffer.replace(extIdx, convertedViewId.length(), this.contextDefaultSuffix);
            } else {
                buffer.append(this.contextDefaultSuffix);
            }
            convertedViewId = buffer.toString();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("viewId after appending the context suffix " + convertedViewId);
            }
        }
        return convertedViewId;
    }

    public void replaceMarkers(String content, FacesContext context) {
        StateManager.SerializedView view = null;
        Object stateArray = null;
        StateManager stateManager = Util.getStateManager(context);
        try {
            if (!this.checkedForNonDeprecated) {
                this.nonDeprecatedMethodExists = Util.hasDeclaredMethod(stateManager, "saveView");
                this.checkedForNonDeprecated = true;
            }
            if (this.nonDeprecatedMethodExists) {
                stateArray = stateManager.saveView(context);
            } else {
                view = stateManager.saveSerializedView(context);
            }
        }
        catch (IllegalStateException ise) {
            throw new FacesException((Throwable)ise);
        }
        catch (Exception ie) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.SAVING_STATE_ERROR", new Object[0]), (Throwable)ie);
        }
        int beginIndex = 0;
        int markerIndex = 0;
        int markerLen = "com.sun.faces.saveStateFieldMarker".length();
        int contentLen = 0;
        try {
            contentLen = content.length();
            do {
                if (-1 == (markerIndex = content.indexOf("com.sun.faces.saveStateFieldMarker", beginIndex))) {
                    context.getResponseWriter().write(content.substring(beginIndex));
                    continue;
                }
                context.getResponseWriter().write(content.substring(beginIndex, markerIndex));
                if (this.nonDeprecatedMethodExists) {
                    stateManager.writeState(context, stateArray);
                } else {
                    stateManager.writeState(context, view);
                }
                beginIndex = markerIndex + markerLen;
            } while (-1 != markerIndex && beginIndex < contentLen);
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }
}

