/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.el.FacesResourceBundleELResolver;
import com.sun.faces.el.ImplicitObjectELResolverForJsp;
import com.sun.faces.el.ManagedBeanELResolver;
import com.sun.faces.el.PropertyResolverChainWrapper;
import com.sun.faces.el.VariableResolverChainWrapper;
import com.sun.faces.lifecycle.ApplyRequestValuesPhase;
import com.sun.faces.lifecycle.InvokeApplicationPhase;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.lifecycle.ProcessValidationsPhase;
import com.sun.faces.lifecycle.RenderResponsePhase;
import com.sun.faces.lifecycle.RestoreViewPhase;
import com.sun.faces.lifecycle.UpdateModelValuesPhase;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.ResponseStateManager;
import javax.servlet.http.HttpServletRequest;

public class LifecycleImpl
extends Lifecycle {
    private static Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.lifecycle");
    private ArrayList<PhaseListener> listeners = new ArrayList();
    private Phase[] phases = new Phase[]{null, new RestoreViewPhase(), new ApplyRequestValuesPhase(), new ProcessValidationsPhase(), new UpdateModelValuesPhase(), new InvokeApplicationPhase()};
    private Phase response = new RenderResponsePhase();
    protected static final String FIRST_REQUEST_SERVICED = "com.sun.faces.FIRST_REQUEST_SERVICED";

    public void execute(FacesContext context) throws FacesException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("execute(" + context + ")");
        }
        this.populateFacesELResolverForJsp(context);
        for (int i = 1; i < this.phases.length && !context.getRenderResponse() && !context.getResponseComplete(); ++i) {
            this.phase((PhaseId)PhaseId.VALUES.get(i), this.phases[i], context);
            if (!this.reload((PhaseId)PhaseId.VALUES.get(i), context)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Skipping rest of execute() because of a reload");
            }
            context.renderResponse();
        }
    }

    public void render(FacesContext context) throws FacesException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("render(" + context + ")");
        }
        if (!context.getResponseComplete()) {
            this.phase(PhaseId.RENDER_RESPONSE, this.response, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("addPhaseListener(" + listener.getPhaseId().toString() + "," + listener);
        }
        ArrayList<PhaseListener> arrayList = this.listeners;
        synchronized (arrayList) {
            ArrayList temp = (ArrayList)this.listeners.clone();
            temp.add(listener);
            this.listeners = temp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhaseListener[] getPhaseListeners() {
        ArrayList<PhaseListener> arrayList = this.listeners;
        synchronized (arrayList) {
            PhaseListener[] results = new PhaseListener[this.listeners.size()];
            return this.listeners.toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("removePhaseListener(" + listener.getPhaseId().toString() + "," + listener);
        }
        ArrayList<PhaseListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void phase(PhaseId phaseId, Phase phase, FacesContext context) throws FacesException {
        Throwable ex;
        boolean exceptionThrown;
        block28: {
            PhaseListener listener3222;
            PhaseEvent event3222;
            ArrayList tempListeners;
            int i;
            block27: {
                block26: {
                    exceptionThrown = false;
                    ex = null;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("phase(" + phaseId.toString() + "," + context + ")");
                    }
                    i = 0;
                    int maxBefore = 0;
                    tempListeners = (ArrayList)this.listeners.clone();
                    try {
                        if (tempListeners.size() > 0) {
                            PhaseEvent event2 = new PhaseEvent(context, phaseId, (Lifecycle)this);
                            i = 0;
                            while (i < tempListeners.size()) {
                                PhaseListener listener2 = (PhaseListener)tempListeners.get(i);
                                if (phaseId.equals(listener2.getPhaseId()) || PhaseId.ANY_PHASE.equals(listener2.getPhaseId())) {
                                    listener2.beforePhase(event2);
                                }
                                maxBefore = i++;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.WARNING)) break block26;
                        logger.warning("phase(" + phaseId.toString() + "," + context + ") threw exception: " + e + " " + e.getMessage() + "\n" + Util.getStackTraceString(e));
                    }
                }
                if (this.skipping(phaseId, context)) break block27;
                phase.execute(context);
            }
            Object var12_13 = null;
            try {
                if (tempListeners.size() > 0) {
                    event3222 = new PhaseEvent(context, phaseId, (Lifecycle)this);
                    for (i = maxBefore; i >= 0; --i) {
                        listener3222 = (PhaseListener)tempListeners.get(i);
                        if (!phaseId.equals(listener3222.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener3222.getPhaseId())) continue;
                        listener3222.afterPhase(event3222);
                    }
                }
                break block28;
            }
            catch (Throwable e2) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("phase(" + phaseId.toString() + "," + context + ") threw exception: " + e2 + " " + e2.getMessage() + "\n" + Util.getStackTraceString(e2));
                }
                break block28;
            }
            {
                catch (Exception e) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "executePhase(" + phaseId.toString() + "," + context + ") threw exception", e);
                    }
                    ex = e;
                    exceptionThrown = true;
                    var12_13 = null;
                    try {
                        if (tempListeners.size() > 0) {
                            event3222 = new PhaseEvent(context, phaseId, (Lifecycle)this);
                            for (i = maxBefore; i >= 0; --i) {
                                listener3222 = (PhaseListener)tempListeners.get(i);
                                if (!phaseId.equals(listener3222.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener3222.getPhaseId())) continue;
                                listener3222.afterPhase(event3222);
                            }
                        }
                        break block28;
                    }
                    catch (Throwable e2) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.warning("phase(" + phaseId.toString() + "," + context + ") threw exception: " + e2 + " " + e2.getMessage() + "\n" + Util.getStackTraceString(e2));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block29: {
                    Object var12_14 = null;
                    try {
                        if (tempListeners.size() > 0) {
                            PhaseEvent event3222 = new PhaseEvent(context, phaseId, (Lifecycle)this);
                            for (i = maxBefore; i >= 0; --i) {
                                PhaseListener listener3222 = (PhaseListener)tempListeners.get(i);
                                if (!phaseId.equals(listener3222.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener3222.getPhaseId())) continue;
                                listener3222.afterPhase(event3222);
                            }
                        }
                    }
                    catch (Throwable e2) {
                        if (!logger.isLoggable(Level.WARNING)) break block29;
                        logger.warning("phase(" + phaseId.toString() + "," + context + ") threw exception: " + e2 + " " + e2.getMessage() + "\n" + Util.getStackTraceString(e2));
                    }
                }
                throw throwable;
            }
        }
        if (exceptionThrown) {
            while (ex.getCause() != null) {
                ex = ex.getCause();
            }
            if (!(ex instanceof FacesException)) {
                ex = new FacesException(ex);
            }
            throw (FacesException)ex;
        }
    }

    private boolean reload(PhaseId phaseId, FacesContext context) {
        if (!phaseId.equals(PhaseId.RESTORE_VIEW)) {
            return false;
        }
        if (!(context.getExternalContext().getRequest() instanceof HttpServletRequest)) {
            return false;
        }
        String renderkitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderkitId);
        boolean postback = rsm.isPostback(context);
        return !postback;
    }

    private boolean skipping(PhaseId phaseId, FacesContext context) {
        if (context.getResponseComplete()) {
            return true;
        }
        return context.getRenderResponse() && !phaseId.equals(PhaseId.RENDER_RESPONSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateFacesELResolverForJsp(FacesContext context) {
        Map applicationMap = context.getExternalContext().getApplicationMap();
        String requestServiced = (String)applicationMap.get(FIRST_REQUEST_SERVICED);
        if (requestServiced != null) {
            return;
        }
        Map map = applicationMap;
        synchronized (map) {
            requestServiced = (String)applicationMap.get(FIRST_REQUEST_SERVICED);
            if (requestServiced == null) {
                applicationMap.put(FIRST_REQUEST_SERVICED, "true");
                ApplicationAssociate appAssociate = ApplicationAssociate.getInstance(context.getExternalContext());
                CompositeELResolver compositeELResolverForJsp = appAssociate.getFacesELResolverForJsp();
                if (compositeELResolverForJsp == null) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("FacesELResolvers not registered with Jsp.");
                    }
                    return;
                }
                compositeELResolverForJsp.add((ELResolver)new ImplicitObjectELResolverForJsp());
                compositeELResolverForJsp.add((ELResolver)new ManagedBeanELResolver());
                compositeELResolverForJsp.add((ELResolver)new FacesResourceBundleELResolver());
                ArrayList elResolversFromFacesConfig = appAssociate.geELResolversFromFacesConfig();
                if (elResolversFromFacesConfig != null) {
                    Iterator it = elResolversFromFacesConfig.iterator();
                    while (it.hasNext()) {
                        compositeELResolverForJsp.add((ELResolver)it.next());
                    }
                }
                if (appAssociate.getLegacyVariableResolver() != null) {
                    compositeELResolverForJsp.add((ELResolver)new VariableResolverChainWrapper(appAssociate.getLegacyVariableResolver()));
                } else if (appAssociate.getLegacyVRChainHead() != null) {
                    compositeELResolverForJsp.add((ELResolver)new VariableResolverChainWrapper(appAssociate.getLegacyVRChainHead()));
                }
                if (appAssociate.getLegacyPropertyResolver() != null) {
                    compositeELResolverForJsp.add((ELResolver)new PropertyResolverChainWrapper(appAssociate.getLegacyPropertyResolver()));
                } else if (appAssociate.getLegacyPRChainHead() != null) {
                    compositeELResolverForJsp.add((ELResolver)new PropertyResolverChainWrapper(appAssociate.getLegacyPRChainHead()));
                }
                ArrayList elResolversFromApplication = appAssociate.getApplicationELResolvers();
                if (elResolversFromApplication != null) {
                    Iterator it = elResolversFromApplication.iterator();
                    while (it.hasNext()) {
                        compositeELResolverForJsp.add((ELResolver)it.next());
                    }
                }
            }
        }
    }
}

