/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.JSFVersionTracker;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.render.ResponseStateManager;
import javax.servlet.http.HttpServletRequest;

public class RestoreViewPhase
extends Phase {
    private static Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.lifecycle");

    public PhaseId getId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void execute(FacesContext facesContext) throws FacesException {
        Object request;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Entering RestoreViewPhase");
        }
        if (null == facesContext) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR", new Object[0]));
        }
        Util.getViewHandler(facesContext).initView(facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = null;
        if (viewRoot != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found a pre created view in FacesContext");
            }
            locale = facesContext.getExternalContext().getRequestLocale();
            facesContext.getViewRoot().setLocale(locale);
            this.doPerComponentActions(facesContext, (UIComponent)viewRoot);
            return;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String viewId = (String)requestMap.get("javax.servlet.include.path_info");
        if (viewId == null) {
            viewId = facesContext.getExternalContext().getRequestPathInfo();
        }
        if (viewId == null) {
            viewId = (String)requestMap.get("javax.servlet.include.servlet_path");
        }
        if (viewId == null && (request = facesContext.getExternalContext().getRequest()) instanceof HttpServletRequest) {
            viewId = ((HttpServletRequest)request).getServletPath();
        }
        if (viewId == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("viewId is null");
            }
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_REQUEST_VIEW_ERROR", new Object[0]));
        }
        if (this.isPostback(facesContext)) {
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            viewRoot = viewHandler.restoreView(facesContext, viewId);
            if (null == viewRoot) {
                JSFVersionTracker tracker = ApplicationAssociate.getInstance(facesContext.getExternalContext()).getJSFVersionTracker();
                if (null != tracker) {
                    JSFVersionTracker.Version toTest = tracker.getVersionForTrackedClassName(viewHandler.getClass().getName());
                    JSFVersionTracker.Version currentVersion = tracker.getCurrentVersion();
                    boolean viewHandlerIsOld = false;
                    boolean stateManagerIsOld = false;
                    viewHandlerIsOld = toTest.compareTo(currentVersion) < 0;
                    toTest = tracker.getVersionForTrackedClassName(facesContext.getApplication().getStateManager().getClass().getName());
                    boolean bl = stateManagerIsOld = toTest.compareTo(currentVersion) < 0;
                    if ((viewHandlerIsOld || stateManagerIsOld) && null != (viewRoot = viewHandler.createView(facesContext, viewId))) {
                        facesContext.renderResponse();
                    }
                }
                if (null == viewRoot) {
                    Object[] params = new Object[]{viewId};
                    throw new ViewExpiredException(MessageUtils.getExceptionMessageString("com.sun.faces.RESTORE_VIEW_ERROR", params), viewId);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Postback: Restored view for " + viewId);
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("New request: creating a view for " + viewId);
            }
            viewRoot = Util.getViewHandler(facesContext).createView(facesContext, viewId);
            facesContext.renderResponse();
        }
        assert (null != viewRoot);
        facesContext.setViewRoot(viewRoot);
        this.doPerComponentActions(facesContext, (UIComponent)viewRoot);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Exiting RestoreViewPhase");
        }
    }

    private boolean isPostback(FacesContext context) {
        String renderkitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderkitId);
        return rsm.isPostback(context);
    }

    protected void doPerComponentActions(FacesContext context, UIComponent uic) {
        ValueExpression valueExpression = null;
        valueExpression = uic.getValueExpression("binding");
        if (null != valueExpression) {
            valueExpression.setValue(context.getELContext(), (Object)uic);
        }
        Iterator kids = uic.getFacetsAndChildren();
        while (kids.hasNext()) {
            this.doPerComponentActions(context, (UIComponent)kids.next());
        }
    }
}

